/***************************************************************************
                          cpskdemodulator.h  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/


#ifndef CPSKDEMODULATOR_H
#define CPSKDEMODULATOR_H

#include "constants.h"
#include <math.h>
#include <complex.h>
#include <stdlib.h>


#include "crxdisplay.h"
#include "cdemodulator.h"


class CPskDemodulator  : public CDemodulator
{
 Q_OBJECT
public:
	CPskDemodulator();
	virtual ~CPskDemodulator();
	bool Init(double Fs ,int BlockSize);

	void ProcessInput( double *pIn);
// Variables
#ifdef AFC_DEBUG	
	double m_FreqError;
	double m_QFreqError;
#endif

	
protected:

// Methods
/** Decodes the symbol depending on the PskModes */	
	virtual void DecodeSymbol( double_complex newsamp) = 0;
/** Calculates the Cuality of the signal -- depends on the mode */	
	virtual	void CalcQuality( double angle ) = 0;	
	
// Variables		
	double m_I0;		// 2 stage I/Q delay line variables
	double m_I1;
	double m_Q0;
	double m_Q1;
	int m_BitAcc;
	bool m_LastBitZero;
	unsigned char* m_VaricodeDecTbl;
	int m_OnCount;
	int m_OffCount;	
#ifndef AFC_DEBUG
	double m_FreqError;
	double m_QFreqError;
#endif	
	double m_DevAve;
	double ferror,dp;	
private:
	int m_ClkErrTimer;
	int m_ClkErrCounter;
	int m_ClkError;

//methods


	bool SymbSync(double_complex sample);
	void CalcBitFilter(  double_complex Samp);
	double CalcAGC( double_complex Samp );
	double CalcFreqError( double_complex IQ );
//variables
	double m_QPSKprob[4];
	int m_LastPkPos;

///	int m_TrigInhib;
	int m_SampCnt;
	bool m_DispTrig;

	int m_BlockSize;
	double m_BitPhaseInc;
	double m_BitPhasePos;
	double m_SyncAve[21];

	double m_SignalLevel;
	double m_Fs;

	double_complex* m_pQue1;
	double_complex* m_pQue2;
	double_complex* m_pQue3;
	double_complex* m_pInPtr1;
	double_complex* m_pInPtr2;
	double_complex* m_pInPtr3;

	double_complex m_FreqSignal;
	double_complex m_BitSignal;
	double m_phzinc;

// Local variables for various functions that need to be saved between calls
	double m_AGCave;
	double_complex m_z1; //Old Version of Freqerror
	double_complex m_z2; // dito
	double m_FerAve;
	double m_LastFreq;
	double m_VcoPhz;
	int	m_PkPos;
	int	m_NewPkPos;
	int m_BitPos;
  double max;	
/** Some Variable for CalcQuality */
double fe1,fe2,ferror1,ferror2;
double dp1,dp2;


public slots:
signals: // Signals
  /** emits this signal if the user changed the cursor
and with it the desired RX- Frequency */
//  void rxFrequencyChanged(double);
//	void newSymbol(char );
//	void newPhaseValue(int,float_complex);
//	void setFastSquelch(bool);
//	void setSquelchValue(int);
};

#endif
