import sys, os, unittest, linda, tempfile
from linda import clparser
from linda.output import OutputFormats
from linda.parser.clparser import CLParser

class LongOutputTest(unittest.TestCase):
    def setUp(self):
        self.filename = tempfile.mkstemp()[1]
        linda.outputformats = OutputFormats()
        execfile('output/long.py')
        for klass in linda.outputformats.registry.keys():
            self.instance = linda.outputformats.registry[klass]()
        clparser = CLParser()
        
    def tearDown(self):
        os.unlink(self.filename)
        
    def test_output(self):
        "Check the output LongOutput gives"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type = 'Error'
        self.instance.description = ['Lala']
        self.instance.data = []
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        data = []
        for line in f:
            data.append(line[:-1])
        self.assertEqual(data, ['Package: test', 'Type: Error', \
            'Description: Lala'])
        f.close()
        f = open(self.filename, 'w')
        f.close()

    def test_output_data(self):
        "Check the output LongOutput gives with data provided"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type = 'Error'
        self.instance.description = ['%s Lala %s']
        self.instance.data = ['a', 'b']
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        data = []
        for line in f:
            data.append(line[:-1])
        self.assertEqual(data, ['Package: test', 'Type: Error', \
            'Description: a Lala b'])
        f.close()
        f = open(self.filename, 'w')
        f.close()

