# Checks for the Common Debian Build System
# Copyright 2003 Colin Walters <walters@debian.org>
# Minor fixes by Steve Kowalik to fit in the New World Order of Linda 0.3

import re
from linda import checks, libchecks
from linda.dpkgver import DpkgVersion
from linda.parser.makefile import MakefileParser

class CDBSCheck(libchecks.LindaChecker):
    "Check a package's use of cdbs."
    def check_source_2(self):
        self.check_cdbs()

    def check_cdbs(self):
        uses = {'cdbs': 0, 'debhelper': 0}
        build_deps = {'cdbs': self._hasbuilddep('cdbs'), 'debhelper': \
            self._hasbuilddep('debhelper')}
        mfp = MakefileParser(os.path.join(self.information['dir'], \
            'debian/rules'))
        for include in mfp.includes:
            if include.find('/usr/share/cdbs') != -1:
                uses['cdbs'] = 1
            if re.match('/usr/share/cdbs/[0-9]+/rules/debhelper\.mk', \
                include):
                uses['debhelper'] = 1
        if build_deps['cdbs'] and not uses['cdbs']:
            self.signal_error('no-cdbs-but-build-dep')
        if not build_deps['cdbs'] and uses['cdbs']:
            self.signal_error('missing-build-dep-on-cdbs')
        if not build_deps['debhelper'] and uses['debhelper']:
            self.signal_error('missing-build-dep-on-debhelper')
        elif uses['debhelper']:
            for version in build_deps['debhelper']['relation']:
                if version == [None, None] or DpkgVersion(version[1]) < '4.1':
                    self.signal_error('cdbs-debhelper-build-dep-too-old')

    def _hasbuilddep(self, pkg):
        for key in ('build-depends', 'build-depends-indep'):
            if self.information['control']['self'][0].has_key(key):
                if self.information['control']['self'][0][key].has_key(pkg):
                    if self.information['control']['self'][0][key][pkg]:
                        return self.information['control']['self'][0][key][pkg]
        return None
    
checks.register(CDBSCheck)

