/****************************************************************************
**
** $Id: noncvslistview.cpp,v 1.13 2001/10/23 23:27:29 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <stdio.h>
#include <qlistview.h>
#include <qevent.h>
#include <qpopupmenu.h>

#include "noncvslistview.h"
#include "globals.h"
#include "PixmapCache.h"


NonCvsListView::NonCvsListView(QWidget *Parent) : 
	QListView(Parent), m_pPopupMenu(0), m_PrevCount(0)
{
	/* Use extended selection mode.  When we click on this
	 * window we usually want to operate on a single file by using
	 * the menu unless the user uses the shift or control key.
	 * We don't want to use the standard multiple selection mode
	 * because the point in having a tree view is so we can perform
	 * the operation on the whole directory hierarchy in one go.
	 */
	setSelectionMode (QListView::Extended);
	setAllColumnsShowFocus(true);

	m_pPopupMenu = new QPopupMenu(this);
	m_pPopupMenu->insertItem(QIconSet(findEmbeddedPixmap("FileASCII16x16")),
				 tr("Add ASCII file"), this,
				 SIGNAL(addFiles()));
	m_pPopupMenu->insertItem(QIconSet(findEmbeddedPixmap ("FileBinary16x16")),
				 tr("Add binary file"), this,
				 SIGNAL(addBinFiles()));
	m_pPopupMenu->insertSeparator();
	m_pPopupMenu->insertItem(QIconSet(findEmbeddedPixmap ("Delete16x16")),
				 tr("Delete from disk"), this,
				 SIGNAL(deleteNonCvsFiles()));

        addColumn(tr("Name"));
        addColumn(tr("Modified (local)"));
        addColumn(tr("Modified (UTC)"));
        setColumnWidth(0,NONCVSLISTVIEW_TABWIDTH_NAME);
        setColumnWidth(1,NONCVSLISTVIEW_TABWIDTH_MODLOCAL);
        setColumnWidth(2,NONCVSLISTVIEW_TABWIDTH_MODUTC);

        connect(this, SIGNAL(doubleClicked(QListViewItem *)),
		this, SLOT(selFile(QListViewItem *)));
}


NonCvsListView::~NonCvsListView()
{
}


void NonCvsListView::viewportMousePressEvent (QMouseEvent * ev)
{
	if (!globalListViewsEnabled)
		return;

	if (!hasFocus() && !viewport()->hasFocus())
		setFocus();

	QListView::viewportMousePressEvent(ev);

	QListViewItem *item;

	if ((ev->button() == QMouseEvent::RightButton) &&
	    ((item = itemAt(ev->pos())) != 0))
	{
		setSelected (item, true);
		setCurrentItem (item);

		m_pPopupMenu->popup(mapToGlobal(ev->pos()) + QPoint(10, 5));
		m_pPopupMenu->show();
	}
}


void NonCvsListView::selFile( QListViewItem * it )
{
        clearSelection();
	emit doubleClickedFile( it->text(0) );
}


void NonCvsListView::signalState(void)
{
        if (childCount() != m_PrevCount)
	{
		m_PrevCount = childCount();
		emit itemCount(m_PrevCount);
        }
}
