#ifndef PROFILESDIALOGIMPL_H
#define PROFILESDIALOGIMPL_H

#include "config.h"
#include "ac_system_defs.h"

#include <qlist.h>

#include "profile.h"
#include "cfg.h"
#include "ProfilesDialog.h"

class ProfilesDialogImpl : public ProfilesDialog
{ 
    Q_OBJECT

public:
    ProfilesDialogImpl(QStringList *userList, QStringList *serverList,
		       QStringList *repositoryList, QStringList *profileList,
		       QWidget* parent = 0, const char* name = 0);
    ~ProfilesDialogImpl();

protected slots:
    void actNameItem(const QString&);
    void addItem();
    void apply();
    void deleteItem();
    void modList();
    void actItems(const QString&);
    void accept();

private:
    enum accessMethod { Password, RemoteShell, Local_NFS };

    accessMethod getMethod(const QString& text);
    void updateComboList();
    void deleteEntry(QStringList* list, const QString item);

    lincvsProfile        *pIndex;    
    QList<lincvsProfile>  tmpList;
    QList<lincvsProfile>  delList;
    QStringList          *p_userList;
    QStringList          *p_serverList;
    QStringList          *p_repositoryList;
    QStringList          *p_profileList;
};

#endif // PROFILESDIALOGIMPL_H
