/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/CvsFileViewer.h,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/09 22:50:34 $
 *!!	$Revision: 1.4 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#ifndef CVSFILEVIEWER_H
#define CVSFILEVIEWER_H


#include "config.h"

#include <qarray.h>
#include <qtableview.h>
#include <qlist.h>


class CvsFileViewerItem;
class CvsFileViewerItemList;


class CvsFileViewer : public QTableView
{
	Q_OBJECT
    
public:

	CvsFileViewer (QWidget *parent=0, const char *name=0);
	~CvsFileViewer ();

	void append (QString Text, QString Revision = "",
		     QString Author = "", QString Date = "");
	virtual int cellWidth (int col);
	virtual QSize sizeHint () const;
	virtual void paintCell (QPainter *p, int row, int col);
  
private:
	friend class CvsFileViewerItem;
	static const unsigned int NUMCOLS = 5; 

	CvsFileViewerItemList *items;
	QArray<int> ColumnWidth;
};


#endif // CVSFILEVIEWER_H
