// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

// QT
#include <qfontdialog.h>
#include <qcolordialog.h>

#include "utils.h"
#include "event.h"

// Classess
extern TShellEx  *ShellEx;

// Global variables
extern TAttrs FormAttrsTb[10];




void TShellEx::customEvent(QCustomEvent *e)
{
   if ( e->type() == 65432 ) 
   {  
      ShExLineEvent* shln = (ShExLineEvent*)e;
      
      ShellOut->insertItem(shln->line());
      ShellOut->setCurrentItem(ShellOut->count()-1);
      ShellOut->setSelected(ShellOut->count()-1, FALSE);
      ShellOut->ensureCurrentVisible();
      
   }
}


void TShellEx::hideEvent( QHideEvent *e )
{
  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}



void TShellEx::UpdateFormAttrs()
{
  QFontInfo fi (ShellOut->font());
  QColor font_color(ShellOut->foregroundColor());
  QColor background(ShellOut->paletteBackgroundColor());
  
  FormAttrsTb[6].FontAttrs.Name      =  fi.family();
  FormAttrsTb[6].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[6].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[6].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[6].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[6].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[6].FormAttrs.Color  =  ShellOut->paletteBackgroundColor().name();
  FormAttrsTb[6].FormAttrs.x      =  ShellEx->x();
  FormAttrsTb[6].FormAttrs.y      =  ShellEx->y();
  FormAttrsTb[6].FormAttrs.height =  ShellEx->height();
  FormAttrsTb[6].FormAttrs.width  =  ShellEx->width();

}


void TShellEx::showEvent( QShowEvent * e )
{
  if ( ! e->spontaneous ()  )
  {
  ShellOut->setDragAutoScroll( TRUE );
  
  QFont fi;
  QColor color; //(MsgList->paletteBackgroundColor());
  
  
  fi.setFamily(FormAttrsTb[6].FontAttrs.Name);
  fi.setPointSize(FormAttrsTb[6].FontAttrs.Size);
  
  fi.setFixedPitch(FormAttrsTb[6].FontAttrs.Pitch);
  fi.setBold(FormAttrsTb[6].FontAttrs.Bold);
  fi.setItalic(FormAttrsTb[6].FontAttrs.Italic);
  ShellOut->setFont( fi );

  color.setNamedColor(FormAttrsTb[6].FormAttrs.Color);
  ShellOut->setPaletteBackgroundColor(color);
  ShellOut->setPaletteForegroundColor (FormAttrsTb[6].FontAttrs.Color); // Font Color
  
  move( FormAttrsTb[6].FormAttrs.x, FormAttrsTb[6].FormAttrs.y );
  resize( FormAttrsTb[6].FormAttrs.width, FormAttrsTb[6].FormAttrs.height );
  }
}
