/***********************************************************************************

	Copyright (C) 2007-2009 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HELPERS_HEADER
#define LIFEOGRAPH_HELPERS_HEADER


#include <iostream>
#include <fstream>

#include <gcrypt.h>

#include <gtkmm.h>

#include <libintl.h>

// DEFINITIONS FOR LIBGETTEXT
#define _(String)               gettext(String)
#define gettext_noop(String)    String
#define N_(String)              gettext_noop(String)
// END OF LIBGETTEXT DEFINITIONS

//FIXME: these are temporary
#define PACKAGE     "lifeograph"
#define LOCALEDIR   "/usr/share/locale"
//TODO(0.5.X): use the methods explained here:
// http://live.gnome.org/ThemableAppSpecificIcons
// and here:
// http://live.gnome.org/GnomeGoals/AppIcon
#define PIXMAPDIR	"/usr/share/pixmaps"
#define ICONDIR		"/usr/share/lifeograph/icons"


namespace LIFEO
{

const int			MAX_RECENT_FILE_COUNT( 8 );

// GLOBAL FUNCTIONS
long				convert_string( const std::string& );

Gdk::Color			contrast( const Gdk::Color&, const Gdk::Color& );
Gdk::Color			midtone( const Gdk::Color&, const Gdk::Color& );

std::ios::pos_type	get_file_size( std::ifstream& );

void				open_url( Gtk::AboutDialog&, const Glib::ustring& );
void				mail_to( Gtk::AboutDialog&, const Glib::ustring& );

typedef sigc::signal< void > SignalVoid;

class Cipher
{
	public:
		static const int	cCIPHER_ALGORITHM	= GCRY_CIPHER_AES256;
		static const int	cCIPHER_MODE		= GCRY_CIPHER_MODE_CFB;
		static const int	cIV_SIZE			= 16; // = 128 bits
		static const int	cSALT_SIZE			= 16; // = 128 bits
		static const int	cKEY_SIZE			= 32; // = 256 bits
		static const int	cHASH_ALGORITHM		= GCRY_MD_SHA256;

		static void			create_iv(	unsigned char** );
		static void			expand_key(	char const*,
										const unsigned char*,
										unsigned char** );
		static void			create_new_key(	char const*,
											unsigned char**,
											unsigned char** );
		static void			encrypt_buffer(	unsigned char*,
											size_t&,
											const unsigned char*,
											const unsigned char* );
		static void			decrypt_buffer(	unsigned char*,
											size_t&,
											const unsigned char*,
											const unsigned char * );

	protected:

	private:

};


class Error
{
	public:
		Error( const std::string &description )
		{
			std::cout << description << std::endl;
		}

		//~ std::string get_stream () {
			//~ return ErrorStream;
		//~ }

	protected:
		//~ virtual int get_type () {}

};

// ENTRY WIDGET WITH TIP TEXT WHEN IDLE
class EntryIdletext : public Gtk::Entry
{
	public:
		explicit			EntryIdletext( const Glib::ustring& );

	protected:
		virtual void		on_map( void );
		virtual void		on_changed( void );
		virtual bool		on_expose_event( GdkEventExpose* );
		virtual bool		on_focus_in_event( GdkEventFocus* );
		virtual bool		on_key_release_event( GdkEventKey* );

		Glib::ustring		m_idletext;
		bool				m_flag_empty;
};

class Menu2 : public Gtk::Menu
{
	public:
		Menu2() { }

	protected:

	private:

	friend class Menubutton;
};

class Menubutton : public Gtk::ToggleButton
{
	public:
							Menubutton(	const Gtk::StockID&,
										const Glib::ustring&,
										Gtk::ReliefStyle = Gtk::RELIEF_NONE,
										Gtk::IconSize = Gtk::ICON_SIZE_BUTTON );
							Menubutton(	const std::string&,
										const Glib::ustring&,
										Gtk::ReliefStyle = Gtk::RELIEF_NONE );
		virtual				~Menubutton( void );

		Menu2*&				get_menu( void );
		void				release( void );

		void				set_label( const Glib::ustring& );
		void				get_menu_position( int&, int&, bool& );

	protected:
		bool				on_button_press_event( GdkEventButton* );

		Menu2				*m_menu;
		Gtk::Label			*m_label;
		Gtk::Image			*m_icon;
		Gtk::HBox			*m_hbox;
		Gtk::VBox			*m_vbox;

	private:

	friend class Menutoolbutton;
};

class Menutoolbutton : public Gtk::ToolItem
{
	public:
		Menutoolbutton( const Gtk::StockID&, const std::string& );

		Menu2*&			get_menu( void );

	protected:
		void			on_toolbar_reconfigured( void );

		Menubutton		m_button;
};

// FILE FILTERS
class FilefilterAny : public Gtk::FileFilter
{
	public:
		FilefilterAny()
		{
			set_name( _("All Files") );
			add_pattern( "*" );
		}
};

class FilefilterDiary : public Gtk::FileFilter
{
	public:
		FilefilterDiary()
		{
			set_name( _("Diary Files (*.diary)") );
			add_pattern( "*.diary" );
		}
};

class MenuitemRecent : public Gtk::MenuItem
{
	public:
		typedef sigc::signal< void, const std::string& >
									Signal_void_string;

									MenuitemRecent( const std::string& );

		Signal_void_string			signal_removerecent( void )
		{ return m_signal_removerecent; }

	protected:
		virtual bool				on_motion_notify_event( GdkEventMotion* );
		virtual bool				on_leave_notify_event( GdkEventCrossing* );
		virtual bool				on_button_release_event( GdkEventButton* );
		virtual bool				on_button_press_event( GdkEventButton* );

		Gtk::Image					m_icon_remove;
		std::string					m_path;
		bool						m_flag_deletepressed;

		Signal_void_string			m_signal_removerecent;
};

class FilebuttonRecent : public Menubutton
{
	public:
									FilebuttonRecent( const Glib::ustring& );

		int							get_recentcount( void ) const {
			return m_recentcount;
		}
		std::list< std::string >&	get_recentlist( void )
		{
			return m_list_recent;
		}
		std::string					get_filename( void ) const;
		std::string					get_filename_recent( int ) const;
		void						set_filename( const std::string& );
		void						update_filename( void );
		//bool						set_filename (const Glib::ustring&);
		bool						add_recent( const std::string& );
		void						remove_recent( const std::string& );
		void						show_filechooser( void );


		SignalVoid					signal_selection_changed( void );
		SignalVoid					signal_create_file( void );

		bool						handle_motion_notify( GdkEventMotion* );

	protected:
		virtual void				on_create_file( void );
		virtual void				on_size_allocate( Gtk::Allocation& );
		virtual void				on_drag_data_received(
											const Glib::RefPtr<Gdk::DragContext>&,
											int, int,
											const Gtk::SelectionData&, guint, guint );

	private:
		Gtk::FileChooserDialog		*m_filechooserdialog;
		Gtk::Image					m_icon_new;
		Gtk::Image					m_icon_browse;
		std::list< std::string >	m_list_recent;
		int							m_recentcount;
		SignalVoid					m_signal_selectionchanged;
		SignalVoid					m_signal_createfile;
};


} // end of namespace LIFEO

#endif

