/* -*- mode: c++ -*-

  This file is part of the Life library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2005-07-17

  Copyright (C) 2005,2006 EPFL
  Copyright (C) 2007 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file functordomain.cpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2005-07-17
 */
#include <life/lifevf/functordomain.hpp>

namespace Life
{
namespace vf
{
/// \cond detail
double FunctorDomain::lowerBound() const
{
    LIFE_ASSERT( true )( "FunctorDomain::lowerBound() called for a domain without "
                          "a lower bound" );
    return 0.0;
}

double FunctorDomain::upperBound() const
{
    LIFE_ASSERT( true )( "FunctorDomain::upperBound() called for a domain without "
                          "a upper bound" );
    return 0.0;
}

double FunctorDomain::excludedPoint() const
{
    LIFE_ASSERT( true )( "FunctorDomain::excludedPoint() called for a domain without "
                          "an excluded point" );
    return 0.0;
}
/// \endcond
}
}
