//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


#ifndef _xmlrpc_client_class_
#define _xmlrpc_client_class_


#include "request.hpp"
#include "reply.hpp"

namespace xmlrpc
{

  class client
  {
  public:
    client ( const std::string host, const int port )
      : m_host ( host ),
	m_port ( port )
    {}
    ~client()
    {}

    //
    // This method sends a request object
    // to the server at host m_host, connecting
    // to port m_port
    //
    reply send_request ( const request& r ) const;

  private:
    std::string m_host;
    int m_port;

  };

};



#endif
