/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/


/*
 * morphtest2.c
 *
 *   Compares the (now-deprecated) fast hand-generated morph
 *   operations with the generic rasterop version.  
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"


main(int    argc,
     char **argv)
{
l_int32      same, index, xorcount;
char        *filein, *fileout;
PIX         *pixs, *pixs1, *pixt1, *pixt2, *pixt3, *pixt4;
SEL         *sel;
SELA        *sela;
static char  mainName[] = "morphtest2";

    if (argc != 3)
	exit(ERROR_INT(" Syntax:  morphtest2 filein fileout", mainName, 1));

    filein = argv[1];
    fileout = argv[2];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

    sela = selaAddBasic(NULL);
    selaFindSelByName(sela, "sel_5dm", &index, &sel);
    selWriteStream(stderr, sel);

    pixt1 = pixErode(NULL, pixs, sel);

    pixs1 = pixAddBorder(pixs, 32, 0);
    pixt2 = pixErodeFast(NULL, pixs1, MORPH_DIAGONAL, -5);
    pixt3 = pixRemoveBorder(pixt2, 32);

    pixEqual(pixt1, pixt3, &same);

    if (same == 1)
	fprintf(stderr, "operations are identical\n");
    else {
	fprintf(stderr, "operations differ\n");
	pixt4 = pixXor(NULL, pixt1, pixt3);
        pixCountPixels(pixt4, &xorcount, NULL);
	fprintf(stderr, "Number of different pixels: %d\n", xorcount);
    }

    pixWrite(fileout, pixt1, IFF_PNG);
    pixWrite("tempfile", pixt3, IFF_PNG);

    exit(0);
}

