/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * fmorphtest1.c
 *
 *   This tests hand-generated dwa code, which is now deprecated
 *   in favor of auto-generated dwa code.  The dispatcher is in
 *   fmorph.c and the low-level hand-generated code is in fmorphlow.c.
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"

#define   NTIMES         100
#define   IMAGE_SIZE     0.25   /* megapixels */
#define   SEL_SIZE       9 
#define   BASIC_OPS      1.     /* 1 for erosion/dilation; 2 for open/close */
#define   CPU_SPEED      866.


main(int    argc,
     char **argv)
{
l_int32      w, h, i;
l_float32    cputime, epo;
char        *filein, *fileout;
PIX         *pixs, *pixd, *pixt1, *pixt2;
static char  mainName[] = "fmorphtest1";

    if (argc != 3)
	exit(ERROR_INT(" Syntax:  fmorphtest1 filein fileout", mainName, 1));

    filein = argv[1];
    fileout = argv[2];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);

    pixt1 = pixAddBorder(pixs, 32, 0);
    pixt2 = pixCreateTemplate(pixt1);
    startTimer();
    for (i = 0; i < NTIMES; i++) {
	pixDilateFast(pixt2, pixt1, MORPH_HORIZ, 9);
/*	if ((i % 20) == 0) fprintf(stderr, "%d iters\n", i);  */
    }
    cputime = stopTimer();
        /* get the elementary pixel operations per cycle */
    epo = BASIC_OPS * SEL_SIZE * NTIMES * IMAGE_SIZE /(cputime * CPU_SPEED);

    fprintf(stderr, "Time: %7.3f sec\n", cputime);
    fprintf(stderr, "Speed: %7.3f epo/Hz\n", epo);

    pixd = pixRemoveBorder(pixt2, 32);

    pixWrite(fileout, pixd, IFF_BMP);

    exit(0);
}

