<?php 

/*
                    Generic  LDAP  Client  Tool
  _    ____   ___  ____    ____ _   _ ____  _     ___  ____   ____ ____
 | |  |  _ \ / _ \   _ \  |  __\ \/ /   _ \  |   / _ \   _ \ |  __   _ \
 | |  | | \ | |_| | |_) ) | |_  \/ / | |_) ) |  | | | | |_) )| |_ | |_) )
 | |__| |_/ |  _  |  __/  | |__ / /\ |  __/  |__| |_| |  _ / | |__|  _ /
 |_________/ _| |_ _|     |____/_/\_\ _|   |____ \___/ _| \_\ ____ _| \_\


 File:          detail.php
 LDAPExplorer:  Copyright (c) 1999, 2000, 2001 Terrence Miao
 Version:       1.17
 Author:        Terrence Miao <terrence_miao@email.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU Public License along 
 with this package; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 Change Log:

    2001.03.23  - fix a bug that certain characters have special significance 
                  in HTML, e.g. '&', '"', '<', '>' can not be displayed correctly 
                  in "detail" window
                  reported by Thierry Cornilleau <Thierry.Cornilleau@France.Sun.COM>

    2001.01.11  - split right frame into right top and right bottom
                  frames. Display entry details in the top; displaying
                  action buttons in the bottom.

	2000.11.16	- rename files from *.php3 to *.php

	2000.11.09  - change to ldap_get_values () to ldap_get_values_len () 
				  (PHP3 >= 3.0.13, PHP4 >= 4.0RC2). New function is
                  full compatible with old one and do not need patch
                  for PHP any more.

    2000.03.25  - fix a bug that "LDAP result entry index is 0"

    2000.03.20  - fix a secure hole in temporary file "/tmp/LE00****". 
                  which never check the link is followed.
                - a bug on solaris that temporary file directory default
                  is "/var/tmp"

    2000.03.17  - fix a minor bug that Netscape Directory Server will 
                  return "Unable to bind to server" if $bindpw is empty

    2000.03.14  - cascading Style Sheet support added
                - use function rawurlencode () to pass parameters
                - rename DN feature added

    2000.02.29  - fix bug that caused by new attribute called "info"
                  reported by Ilkka Torvinen <ilkka.torvinen@nettipaja.fi>

    1999.10.20  - .png image file format support

    1999.10.19  - substitute double quotes - """ with "&quot;" in inputting
                  field 

    1999.9.22   - upload files feature  

    1999.9.17   - JPEG/GIF image files support

    1999.9.14   - fix bug that can only display one attribute which
                  multiple same attributes in on entries
 */

require ("template/header.inc");

require ('default.php');


$ds = ldap_connect ($host, $port);      

if ($ds) { 

    /* Netscape Directory Server will return "Unable to bind to server" if $bindpw is empty */
    if ((strcmp ($binddn, "") == 0) or (strcmp ($bindpw, "") == 0))
        $r = ldap_bind ($ds);
    else
        $r = ldap_bind ($ds, $binddn, $bindpw); 

    $sr = ldap_read ($ds, $dn, $filter);

    $entries_count = ldap_count_entries ($ds, $sr);

    if ($entries_count == 0) {
        /* force $filter to be "objectclass=*" this time */
        $sr = ldap_read ($ds, $dn, "objectclass=*");

        $entries_count = ldap_count_entries ($ds, $sr);

        if ($entries_count == 0) {
            echo "<BR><BR>\n";
            echo "<CENTER>\n";
            echo "<FONT size=4 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif\"><B>";
            echo "<FONT color=#FF0000>No entry details returned<BR></FONT>";
            echo "</B></FONT>";
            echo "</CENTER>\n";

            require ("template/footer.inc");

            return;
        }
    }

    echo "<BR><BR>";
    // echo "<FORM enctype=\"application/x-www-form-urlencoded\" action=\"submit.php?"; 
    echo "<FORM enctype=\"multipart/form-data\" name=\"entryform\" action=\"submit.php?"; 
    echo "host=" . rawurlencode ($host) . "&port=" . rawurlencode ($port) . "&dn=" . rawurlencode ($dn) . "&binddn=" . rawurlencode ($binddn) . "&bindpw=" . rawurlencode ($bindpw) . "&filter=" . rawurlencode ($filter);
    echo "\" method=\"POST\" target=right>\n";

    echo "<TABLE border=0>\n";

    $entry = ldap_first_entry ($ds, $sr);

    $attrs = ldap_get_attributes ($ds, $entry);

    echo "<TR>";
    echo "<TD align=right valign=center nowrap><B><I>";
    echo "Distinguished Name" . " = &nbsp;&nbsp;</I></B></TD>";
    echo "<TD align=left valign=top>";
    echo "<INPUT type=text ";
    echo "name=" . "newdn" . " "; 
    echo "value=\"" . htmlspecialchars ($dn) . "\" size="; 
    
    if (strlen ($DN) > $default->maxinputlength )
        echo $default->maxinputlength;
    else
        echo strlen ($dn);

    echo "></TD>";
    echo "</TR>\n";

    for ($i = 0; $i < $attrs["count"]; $i++) {

        $attribute = $attrs[$i];
		$attributevalue = ldap_get_values_len ($ds, $entry, $attribute);

        for ($j = 0; $j < $attrs[$attribute]["count"]; $j++) {

            echo "<TR>";
            echo "<TD align=right valign=center nowrap><B><I>";
            echo $attrs[$i] . " = &nbsp;&nbsp;</I></B></TD>";

            echo "<TD align=left valign=top>";

            // $value = $attrs[$attribute][$j];
			$value = $attributevalue[$j];

            /* MIME type data output support */
            if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe") or strstr ($attribute, ";gif") or strstr ($attribute, ";png")) {

			$mm = strlen ($value);
			// echo "attribute = $attribute<BR>";
			// echo "value = $value<BR>";
			// echo "mm = $mm<BR>";
/*
    Because gd 1.6.3 creates PNG images, not GIF images. PNG is a more
    compact format, and full compression is available. Existing code 
    will need modification to call gdImagePng instead of gdImageGif. 

    Unisys holds a patent on the LZW compression algorithm, which is 
    used in fully compressed GIF images. Which ask each website $5000
    bucks if they have gif images. Damn Unisys!!!

    Following codes is another way can let web server output graph directly 
    with generating temporary file.

                $tmpfname = tempnam (".", $default->tmpfile_prefix);

                // get rid of nasty prefix in file path "."
                $tmpfname = substr ($tmpfname, 1);

                $tmpfname = $tmpfname . ".gif";

                $fp = fopen ($tmpfname, "w+");
                fputs ($fp, $value, strlen ($value));
                fclose ($fp);

                $imagesize = GetImageSize ($tmpfname);

                echo "<img src=\"drawgif.php?" . $tmpfname . "\" ";
                echo  $imagesize[3];
                echo " border=0>"; 
*/

                $tmpfname = tempnam (".", $default->tmpfile_prefix);

                /* get rid of nasty prefix in file path "." */
                $tmpfname = substr ($tmpfname, 1);

                if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe"))
                    $tmpfname = $tmpfname . ".jpg";
                elseif (strstr ($attribute, ";gif"))
                    $tmpfname = $tmpfname . ".gif";
                elseif (strstr ($attribute, ";png"))
                    $tmpfname = $tmpfname . ".png";

                $fulltmpfname = $default->root_html . $default->tmpdir . $tmpfname;

                $fp = fopen ($fulltmpfname, "w+");
                fputs ($fp, $value, strlen ($value));
                fclose ($fp);

                $imagesize = GetImageSize ($fulltmpfname);

                echo "<IMG src=\"" . $default->tmpdir . $tmpfname . "\" ";
                echo  $imagesize[3];
                echo " border=0>"; 

                echo "<BR>";
                echo "<INPUT type=text name=default-" . $default->prefix_submit;

                if ($j == 0)
                    echo $attrs[$i] . " "; 
                else
                    echo $attrs[$i] . ";" . $j . " "; 

                echo "type=text";
                echo " value=" . $default->tmpdir . $tmpfname; 
                echo " size=" . strlen ($default->tmpdir . $tmpfname) . ">"; 

                echo "<BR>";
                echo "<INPUT type=hidden name=MAX_FILE_SIZE value=";
                echo $default->maxfsize;
                echo ">";
                echo "<INPUT name=" . $default->prefix_submit;

                if ($j == 0)
                    echo $attrs[$i] . " "; 
                else
                    echo $attrs[$i] . ";" . $j . " "; 

                echo "type=file size=";
                echo $default->maxinputlength - 20;
                echo ">";
            }
            else {
                /* NOT MIME type data */
                $isascii = 1;

                for ($k = 0; $k < strlen ($value); $k++) {

                    $chstr = substr ($value, $k, 1);

                    /* if there is non-print character */
                    if ((ord ($chstr) < 20) or (ord ($chstr) > 126)) {
                        $isascii = 0;
                        break;
                    }
                }

                if ($isascii == 0) {

                    echo "<input type=text name=";
                
                    if ($j == 0)
                        echo $default->prefix_submit . $attrs[$i] . " "; 
                    else
                        echo $default->prefix_submit . $attrs[$i] . ";" . $j . " "; 
                
                    echo "value=\"" . base64_encode ($value) . "\" size=";

                    if (strlen (base64_encode ($value)) > $default->maxinputlength )
                        echo $default->maxinputlength;
                    else
                        echo strlen (base64_encode ($value));

                    echo ">";
                }
                else {

                    /* Netscape LDAP aci has double quotes symbols - """ */ 
                    /* ascii 20 - 126, only character """ need to be substitutedin INPUT field so far */
                    /* $value = str_replace ("\"", "&quot;", $value); */
                    /* $value = rawurlencode ($value); */
					$value4size = $value;
                    $value = htmlspecialchars ($value);

                    echo "<INPUT name=";

                    if ($j == 0)
                        echo $default->prefix_submit . $attrs[$i] . " "; 
                    else
                        echo $default->prefix_submit . $attrs[$i] . ";" . $j . " "; 

                    if (strstr ($attrs[$i], "userpassword")) {
                        echo "type=password ";
                        echo "value=\"" . $value;
                    }
                    else {
                        echo "type=text ";
                        echo "value=\"" . $value;
                    }

                    echo "\" size=";

                    if (strlen ($value4size) > $default->maxinputlength )
                        echo $default->maxinputlength;
                    else
                        echo strlen ($value4size);
            
                    echo ">";
                }

            }
        
            echo "</TD>";
            echo "</TR>\n";
        }
    }

    ldap_unbind ($ds);
}
else {

    echo "Can not create LDAP connection\n";
}


echo "<TR>";
echo "<TD>&nbsp;&nbsp;</TD>";
echo "<TD><BR></TD>";
echo "</TR>\n";

for ($i = 0; $i < $default->newattrnum; $i++) {
    echo "<TR>";
    echo "<TD align=right valign=center nowrap><B><I>";
    echo "New Attr Name : " . "&nbsp;&nbsp;</I></B></TD>";
    echo "<TD align=left><INPUT type=text name=newattr" . $i . " size=" . $default->maxinputlength . ">"; 
    echo "</TD>";
    echo "</TR>\n";
    echo "<TR>";
    echo "<TD align=right valign=center nowrap><B><I>";
    echo "Text Value : &nbsp;&nbsp;</I></B></TD>";
    echo "<TD align=left><INPUT type=text name=attrvalue" . $i . " size=" . $default->maxinputlength . ">"; 
    echo "</TD>";
    echo "</TR>\n";
    echo "<TR>";
    echo "<TD align=right valign=center nowrap><B><I>";
    echo "OR Binary File : &nbsp;&nbsp;</I></B></TD>";
    echo "<TD align=left><INPUT type=file name=attrbinvalue" . $i . " size=" . $default->maxinputlength . ">"; 
    echo "</TD>";
    echo "</TR>\n";

    echo "<TR><TD><BR></TD><TD><BR></TD></TR>\n";
}

/* 
echo "<TR>";
echo "<TD></TD>";
echo "<TD align=center>";
echo "<BR>";
echo "<HR>\n";
echo "<TABLE width=100%><TR>";
echo "<TD align=CENTER width=20%>";
echo "<INPUT type=submit name=Add value=\"New/Add\">";
echo "</TD>";
echo "<TD align=CENTER width=20%>";
echo "<INPUT type=submit name=Modify value=Modify>";
echo "</TD>";
echo "<TD align=CENTER width=20%>";
echo "<INPUT type=submit name=Delete value=Delete>";
echo "</TD>";
echo "<TD align=CENTER width=20%>";
echo "<INPUT type=submit name=Rename value=Rename>";
echo "</TD>";
echo "<TD align=CENTER width=20%>";
echo "<INPUT type=reset value=Reset>";
echo "</TD>";
echo "</TR></TABLE>\n";
echo "</TD></TR>\n";
*/

echo "</TABLE>\n";

echo "<INPUT type=hidden name=ActionType value=idontknow>";

echo "</FORM>\n";

require ("template/footer.inc");

?> 
