/*
 * $Id: kl_mem_alpha.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_ALPHA_H
#define __KL_MEM_ALPHA_H

/* XXX - the following macros are used by functions in kl_page.c and in */
/*       function kl_virtop, they still have to be defined properly, */
/*       all the following macros have first to be set with correct values. */
/*       I don't have a clue what values to use for alpha architecture!!! */

#ifndef ALPHA_FULLY_IMPLEMENTED
#error "CODE REQUIRES PORT TO HOST ARCHITECTURE"
#else

#define KL_KSTACK_SIZE_ALPHA        0x4000ULL
#define KL_PAGE_OFFSET_ALPHA        0x0

#define KL_PAGE_SHIFT_ALPHA         12
#define KL_PAGE_SIZE_ALPHA          (1UL << KL_PAGE_SHIFT_ALPHA)
#define KL_PAGE_MASK_ALPHA          (~(KL_PAGE_SIZE_ALPHA-1))

/* I filled in values from kl_page.c. Don't know if they are correct... */
#define KL_PGDIR_SHIFT_ALPHA   (KL_PAGE_SHIFT_ALPHA+(KL_PAGE_SHIFT_ALPHA-3)*2)
#define KL_PGDIR_SIZE_ALPHA    (1UL<<KL_PGDIR_SHIFT_ALPHA)
#define KL_PGDIR_MASK_ALPHA    (~(KL_PGDIR_SIZE_ALPHA-1))
#define KL_PMD_SHIFT_ALPHA     (KL_PAGE_SHIFT_ALPHA+(KL_PAGE_SHIFT_ALPHA-3)*1)
#define KL_PMD_SIZE_ALPHA      (1UL<<KL_PMD_SHIFT_ALPHA)
#define KL_PMD_MASK_ALPHA      (~(KL_PMD_SIZE_ALPHA-1))

#define KL_PTRS_PER_PGD_ALPHA  (1UL<<(KL_PAGE_SHIFT_ALPHA-3)) 
#define KL_PTRS_PER_PMD_ALPHA  (1UL<<(KL_PAGE_SHIFT_ALPHA-3))
#define KL_PTRS_PER_PTE_ALPHA  (1UL<<(KL_PAGE_SHIFT_ALPHA-3))

/* this values describe the bits of pgd/pmd/pte entries that are status bits */
/* and therefor have to be masked in order to get valid addresses */
#define KL_PMD_BASE_MASK_ALPHA      0
#define KL_PT_BASE_MASK_ALPHA       0
#define KL_PAGE_BASE_MASK_ALPHA     0

#endif /* #ifndef ALPHA_FULLY_IMPLEMENTED */


/* functions needed for dump architecture specific memory mapping */
kaddr_t kl_mmap_virtop_alpha(
	kaddr_t vaddr   /* kernel virtual address */,
	void *mmp       /* pointer to struct mm_struct */);

kaddr_t kl_kernelstack_alpha(kaddr_t task);

#endif /* __ASM_KL_MEM_H */
