/*
 * $Id: kl_dump_s390.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

/* This header file holds the architecture specific crash dump header */
#ifndef __KL_DUMP_S390_H
#define __KL_DUMP_S390_H

/* definitions */
#define KL_DUMP_MAGIC_NUMBER_S390    0xdeaddeadULL  /* magic number */
#define KL_DUMP_VERSION_NUMBER_S390  0x3            /* version number */

/* dummy asm header - not used by s390
 */
typedef struct kl_dump_header_s390_s {
        uint64_t magic_number; /* magic number for this dump (unique)*/
        uint32_t version;      /* version number of this dump */
        uint32_t header_size;  /* size of this header */
} __attribute__((packed))  kl_dump_header_s390_t;

#if defined(DUMP_ARCH_S390)
int kl_set_dumparch_s390(void);
#endif
#if defined(DUMP_ARCH_S390X)
int kl_set_dumparch_s390x(void);
#endif

#endif /* __KL_DUMP_S390_H */
