/*
 * $Id: kl_klconfig.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <klib.h>
#include <kl_klconfig.h>

char *comp_name[] = {
	"UNKNOWN",	   /*  0 */
	"CPU",             /*  1 */
	"HUB",             /*  2 */
	"MEMBNK",          /*  3 */
	"XBOW",            /*  4 */
	"BRI",             /*  5 */
	"IOC3",            /*  6 */
	"PCI",             /*  7 */
	"VME",             /*  8 */
	"ROU",             /*  9 */
	"GFX",             /* 10 */
	"SCSI",            /* 11 */
	"FDDI",            /* 12 */
	"MIO",             /* 13 */
	"DISK",            /* 14 */
	"TAPE",            /* 15 */
	"CDROM",           /* 16 */
	"HUB_UART",        /* 17 */
	"IOC3ENET",        /* 18 */
	"IOC3UART",        /* 19 */
	"UNUSED",          /* 20 */
	"IOC3PCKM",        /* 21 */
	"RAD",             /* 22 */
	"HUB_TTY",         /* 23 */
	"IOC3_TTY",        /* 24 */
	"FIBERCHANNEL",    /* 25 */
	"MOD_SERIAL_NUM",  /* 26 */
	"IOC3MS",          /* 27 */
	"TPU",             /* 28 */
	"GSN_A",           /* 29 */
	"GSN_B",           /* 30 */
	"XTHD",            /* 31 */
	"QLFIBRE",         /* 32 */
	"1394",            /* 33 */
	"USB",             /* 34 */
	"USBKBD",          /* 35 */
	"USBMS",           /* 36 */
	"SCSI_CTLR",       /* 37 */
	"PEBRICK",         /* 38 */
	"GIGE",            /* 39 */
	"IDE",             /* 40 */
};

/*
 * offset_to_addr()
 */
kaddr_t
offset_to_addr(kaddr_t klcfg, kaddr_t offset)
{
	int nasid;
	kaddr_t base_addr, addr;

	nasid = ADDR_TO_NASID(klcfg);
	base_addr = BASE_ADDR(nasid);

	addr = base_addr + offset;
	return(addr);
}

/*
 * get_kl_config_hdr()
 */
void *
get_kl_config_hdr(kaddr_t klconfig, int aflg)
{
	int klconfig_sz = 0;
	void *klconfigp = NULL;

	klconfig_sz = kl_struct_len("kl_config_hdr");
	klconfigp = kl_alloc_block(klconfig_sz, aflg);
        if (kl_get_struct(klconfig, klconfig_sz, klconfigp, "kl_config_hdr")) {
		kl_free_block(klconfigp);
                return((void *)NULL);
        }
	return(klconfigp);
}

/*
 * get_lboard_s()
 */
void *
get_lboard_s(kaddr_t klcfg, kaddr_t offset, int aflg)
{
	int lboard_s_sz;
	void *brd_infop = NULL;
	kaddr_t lboard_addr;

	lboard_s_sz = kl_struct_len("lboard_s");
	lboard_addr = offset_to_addr(klcfg, offset);
	brd_infop = kl_alloc_block(lboard_s_sz, aflg);
	if (kl_get_struct(lboard_addr, lboard_s_sz, brd_infop, "brd_info")) {
		kl_free_block(brd_infop);
		return((void *)NULL);	
	}
	return(brd_infop);
}

/* 
 * get_klinfo()
 */
void *
get_klinfo(kaddr_t compt_addr, int aflg)
{
	int klinfo_sz;
	char klinfo_type;
	void *klinfop;

	/* First thing we do is read in the first character,
	 * to see what type of klinfo struct we need to read in from
	 * memory.
	 */
	GET_BLOCK(compt_addr, 1, &klinfo_type);
	switch(klinfo_type) {
		case KLSTRUCT_CPU: 		/*  1 -- CPU */
			klinfo_sz = kl_struct_len("klcpu_s");
			break;

		case KLSTRUCT_HUB: 		/*  2 -- HUB */
			klinfo_sz = kl_struct_len("klhub_s");
			break;

		case KLSTRUCT_MEMBNK: 		/*  3 -- MEMORY BANK */
			klinfo_sz = kl_struct_len("klmembnk_s");
			break;

		case KLSTRUCT_XBOW: 		/*  4 -- XBOW */
			klinfo_sz = kl_struct_len("klxbow_s");
			break;

		case KLSTRUCT_BRI: 		/*  5 -- BRIDGE */
			klinfo_sz = kl_struct_len("klbri_s");
			break;

		case KLSTRUCT_IOC3:		/*  6 -- IOC3 */
			klinfo_sz = kl_struct_len("klioc3_s");
			break;

		case KLSTRUCT_HUB_UART: 	/* 17 -- HUB */	
			klinfo_sz = kl_struct_len("klhub_uart_s");

		case KLSTRUCT_SCSI_CTLR: 	/* 37 -- SCSI Controller */
			/* SCSI Controller */
			klinfo_sz = kl_struct_len("klscsi_s");
			break;

		case KLSTRUCT_UNUSED:		/* 20 --  XXX UNUSED */
			break;

		case KLSTRUCT_UNKNOWN: 		/*  0 */
		case KLSTRUCT_PCI:		/*  7 -- PCI */
		case KLSTRUCT_VME:		/*  8 -- VME BUS/DEVICE */
		case KLSTRUCT_ROU:		/*  9 -- ROUTER */
		case KLSTRUCT_GFX:		/* 10 -- GRAPHICS Device */
		case KLSTRUCT_SCSI:		/* 11 -- SCSI BUS  */
		case KLSTRUCT_FDDI:		/* 12 -- FDDI */
		case KLSTRUCT_MIO:		/* 13 -- MIO */
		case KLSTRUCT_DISK:		/* 14 -- DISK */
		case KLSTRUCT_TAPE:		/* 15 -- TAPE */
		case KLSTRUCT_CDROM:		/* 16 -- CDROM */
		case KLSTRUCT_IOC3ENET:		/* 18 -- ENET */
		case KLSTRUCT_IOC3UART:		/* 19 -- ENET */
		default:
			klinfo_sz = kl_struct_len("klinfo_s");

	}
	klinfop = kl_alloc_block(klinfo_sz, aflg);
	if (kl_get_struct(compt_addr, klinfo_sz, klinfop, "klinfo")) {
		return((void *)NULL);
	}
	return(klinfop);
}

/*
 * kl_klgraph_addr()
 */
kaddr_t
kl_klgraph_addr(void)
{
        syment_t *sp;

	if (!(sp = kl_lkup_symname("klgraph_addr"))) {
		return((kaddr_t)NULL);
	}
	return(sp->s_addr);
}

/*
 * kl_klconfig_addr()
 */
kaddr_t
kl_klconfig_addr(int nodeid)
{
	kaddr_t klgraph_addr, klconfig;
        syment_t *sp;

        if (!(sp = kl_lkup_symname("klgraph_addr"))) {
                return((kaddr_t)NULL);
        }
	klgraph_addr = sp->s_addr + (nodeid * KL_NBPW);
	klconfig = KL_VREAD_PTR(klgraph_addr);
	return(klconfig);
}
