/*
 * $Id: kl_hwconfig.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <klib.h>
#include <kl_pci.h>
#include <kl_config.h>

/* Prototypes for arch specific functions
 */
#ifdef DUMP_ARCH_IA64
int init_sn2_hwconfig(void);
hwconfig_t *get_sn2_hwconfig(int);
#endif

/*
 * kl_init_hwconfig()
 */
int
kl_init_hwconfig(void)
{
	int status = 0;

	/* Call arch independent hwconfig init routines...
	 */
	kl_pci_init();

	/* Call arch dependent hwconfig init routines...
	 */
        switch (KL_ARCH) {
#ifdef DUMP_ARCH_IA64
                case KL_ARCH_IA64_SN2:
                        status = init_sn2_hwconfig();
                        break;
#endif
        }
	return(status);
}

/* 
 * kl_get_hwconfig()
 */
hwconfig_t *
kl_get_hwconfig(int flags)
{
	hwconfig_t *hcp = (hwconfig_t *)NULL;

	if (kl_init_hwconfig()) {
		return((hwconfig_t *)NULL);
	}

	switch (KL_ARCH) {
#ifdef DUMP_ARCH_IA64
		case KL_ARCH_IA64_SN2:	
			hcp = get_sn2_hwconfig(flags);
			break;
#endif
	}
	return(hcp);
}
