/*
 * $Id: cmds.c,v 1.2 2005/02/25 22:04:04 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int base_cmd(command_t *), base_parse(command_t *);
extern void base_help(command_t *), base_usage(command_t *);
extern char *base_complete(command_t *);

extern int deftask_cmd(command_t *), deftask_parse(command_t *);
extern void deftask_help(command_t *), deftask_usage(command_t *);
extern char *deftask_complete(command_t *);

extern int dis_cmd(command_t *), dis_parse(command_t *);
extern void dis_help(command_t *), dis_usage(command_t *);
extern char *dis_complete(command_t *);

extern int dump_cmd(command_t *), dump_parse(command_t *);
extern void dump_help(command_t *), dump_usage(command_t *);
extern char *dump_complete(command_t *);

extern int findsym_cmd(command_t *), findsym_parse(command_t *);
extern void findsym_help(command_t *), findsym_usage(command_t *);
extern char *findsym_complete(command_t *);

extern int help_cmd(command_t *), help_parse(command_t *);
extern void help_help(command_t *), help_usage(command_t *);
extern char *help_complete(command_t *);

extern int history_cmd(command_t *), history_parse(command_t *);
extern void history_help(command_t *), history_usage(command_t *);
extern char *history_complete(command_t *);

extern int info_cmd(command_t *), info_parse(command_t *);
extern void info_help(command_t *), info_usage(command_t *);
extern char *info_complete(command_t *);

extern int ldcmds_cmd(command_t *), ldcmds_parse(command_t *);
extern void ldcmds_help(command_t *), ldcmds_usage(command_t *);
extern char *ldcmds_complete(command_t *);

extern int savedump_cmd(command_t *), savedump_parse(command_t *);
extern void savedump_help(command_t *), savedump_usage(command_t *);
extern char *savedump_complete(command_t *);

extern int mmap_cmd(command_t *), mmap_parse(command_t *);
extern void mmap_help(command_t *), mmap_usage(command_t *);
extern char *mmap_complete(command_t *);

extern int module_cmd(command_t *), module_parse(command_t *);
extern void module_help(command_t *), module_usage(command_t *);
extern char *module_complete(command_t *);

extern int namelist_cmd(command_t *), namelist_parse(command_t *);
extern void namelist_help(command_t *), namelist_usage(command_t *);
extern char *namelist_complete(command_t *);

extern int page_cmd(command_t *), page_parse(command_t *);
extern void page_help(command_t *), page_usage(command_t *);
extern char *page_complete(command_t *);

extern int pci_cmd(command_t *), pci_parse(command_t *);
extern void pci_help(command_t *), pci_usage(command_t *);
extern char *pci_complete(command_t *);

extern int print_cmd(command_t *), print_parse(command_t *);
extern void print_help(command_t *), print_usage(command_t *);
extern char *print_complete(command_t *);

extern int report_cmd(command_t *), report_parse(command_t *);
extern void report_help(command_t *), report_usage(command_t *);
extern char *report_complete(command_t *);

extern int quit_cmd(command_t *), quit_parse(command_t *);
extern void quit_help(command_t *), quit_usage(command_t *);

extern int search_cmd(command_t *), search_parse(command_t *);
extern void search_help(command_t *), search_usage(command_t *);
extern char *search_complete(command_t *);

extern int set_cmd(command_t *), set_parse(command_t *);
extern void set_help(command_t *), set_usage(command_t *);
extern char *set_complete(command_t *);

extern int sizeof_cmd(command_t *), sizeof_parse(command_t *);
extern void sizeof_help(command_t *), sizeof_usage(command_t *);
extern char *sizeof_complete(command_t *);

extern int stat_cmd(command_t *), stat_parse(command_t *);
extern void stat_help(command_t *), stat_usage(command_t *);
extern char *stat_complete(command_t *);

extern int strace_cmd(command_t *), strace_parse(command_t *);
extern void strace_help(command_t *), strace_usage(command_t *);
extern char *strace_complete(command_t *);

extern int symtab_cmd(command_t *), symtab_parse(command_t *);
extern void symtab_help(command_t *), symtab_usage(command_t *);
extern char *symtab_complete(command_t *);

extern int task_cmd(command_t *), task_parse(command_t *);
extern void task_help(command_t *), task_usage(command_t *);
extern char *task_complete(command_t *);

extern int trace_cmd(command_t *), trace_parse(command_t *);
extern void trace_help(command_t *), trace_usage(command_t *);
extern char *trace_complete(command_t *);

extern int version_cmd(command_t *), version_parse(command_t *);
extern void version_help(command_t *), version_usage(command_t *);
extern char *version_complete(command_t *);

extern int vtop_cmd(command_t *), vtop_parse(command_t *);
extern void vtop_help(command_t *), vtop_usage(command_t *);
extern char *vtop_complete(command_t *);

extern int walk_cmd(command_t *), walk_parse(command_t *);
extern void walk_help(command_t *), walk_usage(command_t *);
extern char *walk_complete(command_t *);

extern int whatis_cmd(command_t *), whatis_parse(command_t *);
extern void whatis_help(command_t *), whatis_usage(command_t *);
extern char *whatis_complete(command_t *);

_command_t  cmdset[] = {
	{"base", 0, base_cmd, base_parse, base_help, base_usage, base_complete},
	{"deftask", 0, deftask_cmd, deftask_parse, deftask_help, deftask_usage,
	 deftask_complete},
	{"dt", "deftask" },
	{"dis", 0, dis_cmd, dis_parse, dis_help, dis_usage, dis_complete},
	{"id", "dis" },
	{"dump", 0, dump_cmd, dump_parse, dump_help, dump_usage, dump_complete},
	{"od", "dump" },
	{"md", "dump" },
	{"findsym", 0, findsym_cmd, findsym_parse, findsym_help, findsym_usage,
	 findsym_complete},
	{"fsym", "findsym"},
	{"symbol", "findsym"},
	{"help", 0, help_cmd, help_parse, help_help, help_usage, help_complete},
	{"?", "help" },
	{"history", 0, 0, 0, history_help, history_usage, history_complete},
	{"h", "history" },
	{"info", 0, info_cmd, info_parse, info_help, info_usage, info_complete},
	{"ldcmds", 0, ldcmds_cmd, ldcmds_parse, ldcmds_help, ldcmds_usage,
	 ldcmds_complete},
	{"savedump", 0, savedump_cmd, savedump_parse, savedump_help,
	 savedump_usage, savedump_complete},
	{"mmap", 0, mmap_cmd, mmap_parse, mmap_help, mmap_usage, mmap_complete},
	{"module", 0, module_cmd, module_parse, module_help, module_usage,
	 module_complete},
	{"namelist", 0, namelist_cmd, namelist_parse, namelist_help,
	 namelist_usage, namelist_complete},
	{"addtypes", "namelist"},
	{"nmlist", "namelist" },
	{"page", 0, page_cmd, page_parse, page_help, page_usage, page_complete},
        {"pci", 0, pci_cmd, pci_parse, pci_help, pci_usage, NULL},
	{"quit", 0, quit_cmd, quit_parse, quit_help, quit_usage, NULL},
	{"q", "quit"},
	{"q!", "quit"},
	{"report", 0, report_cmd, report_parse, report_help, report_usage,
	 report_complete},
	{"search", 0, search_cmd, search_parse, search_help, search_usage, 
	 search_complete},
	{"set", 0, set_cmd, set_parse, set_help, set_usage, set_complete},
	{"sizeof", 0, sizeof_cmd, sizeof_parse, sizeof_help, sizeof_usage,
	 sizeof_complete},
	{"offset", "sizeof"},
	{"version", 0, version_cmd, version_parse, version_help, version_usage,
	 version_complete},
	{"stat", 0, stat_cmd, stat_parse, stat_help, stat_usage, stat_complete},
	{"strace", 0, strace_cmd, strace_parse, strace_help, strace_usage,
	 strace_complete},
	{"symtab", 0, symtab_cmd, symtab_parse, symtab_help, symtab_usage,
	 symtab_complete},
	{"task", 0, task_cmd, task_parse, task_help, task_usage, task_complete},
	{"ps", "task"},
	{"trace", 0, trace_cmd, trace_parse, trace_help, trace_usage,
	 trace_complete},
	{"t", "trace"},
	{"bt", "trace"},
	{"print", 0, print_cmd, print_parse, print_help, print_usage,
	 print_complete},
	{"p", "print" },
	{"pd", "print" },
	{"px", "print" },
	{"po", "print" },
	{"pb", "print" },
	{"vtop", 0, vtop_cmd, vtop_parse, vtop_help, vtop_usage, vtop_complete},
	{"walk", 0, walk_cmd, walk_parse, walk_help, walk_usage, walk_complete},
	{"whatis", 0, whatis_cmd, whatis_parse, whatis_help, whatis_usage,
	 whatis_complete},
	{(char *)0 }
};
