/*
 * $Id: cmd_stat.c,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

void
stat_cmd(command_t *cmd)
{
	char *utsname;

	if((utsname = get_utsname())){
		fprintf(cmd->ofp, "\n");
		fprintf(cmd->ofp, "   sysname : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "sysname"));
		fprintf(cmd->ofp, "  nodename : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "nodename"));
		fprintf(cmd->ofp, "   release : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "release"));
		fprintf(cmd->ofp, "   version : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "version"));
		fprintf(cmd->ofp, "   machine : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "machine"));
		fprintf(cmd->ofp, "domainname : %s\n", (char*)
			K_PTR(utsname, NEW_UTSNAME, "domainname"));
		fprintf(cmd->ofp, "\nLOG_BUF:\n\n");
		kl_free_block(utsname);
	} else {
		fprintf(cmd->efp, "COULD NOT GET SYSINFO!\n\n");
	}	
	print_log_buf(cmd->ofp);
}

#define _STAT_USAGE "[-w outfile]"

/*
 * stat_usage() -- Print the usage string for the 'stat' command.
 */
void
stat_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _STAT_USAGE);
}

/*
 * stat_help() -- Print the help information for the 'stat' command.
 */
void
stat_help(command_t *cmd)
{
	CMD_HELP(cmd, _STAT_USAGE,
	"Display system statistics and the log_buf array, which contains "
	"the latest messages printed via the kernel printf/cmn_err "
	"routines.");
}

/*
 * stat_parse() -- Parse the command line arguments for 'stat'.
 */
int
stat_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FALSE|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * stat_complete() -- Complete arguments of 'stat' command.
 */
char *
stat_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	stat_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
