/*
 * $Id: cmd_rd_ppc64.c,v 1.2 2005/02/23 19:31:32 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int defcpu_ppc64;

#define _RD_USAGE "[-w outfile]"

void
rd_ppc64_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _RD_USAGE);
}

void
rd_ppc64_help(command_t *cmd)
{
	CMD_HELP(cmd, _RD_USAGE,
			"Display the register contents of the default cpu."
			"This command can't be used on a live system ");
}

int
rd_ppc64_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_WRITE), 0)) {
		return(1);
	}
	return 0;
}

int
rd_ppc64_cmd(command_t *cmd)
{
	kl_dump_header_ppc64_t dha;
	uint64_t msr, trap;
	int i;

	if (cmd->nargs != 0) {
		rd_ppc64_usage(cmd);
		return(1);
	}	

	if (CORE_IS_KMEM) {
		fprintf(cmd->efp, "Can't use this command on live system\n");
		return(1);
	}
	
	if (kl_get_dump_header_ppc64(&dha))
		return(1);

	if (defcpu_ppc64 == -1)
		defcpu_ppc64 = KL_GET_UINT32(&dha.dumping_cpu);

	if (!KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].nip)) {
		fprintf(cmd->efp, "NIP is NULL\n");
		fprintf(cmd->efp, "One probable cause:  pt_regs is NULL when Alt-SysRq-D is used to take the dump\n");
	}
		
	fprintf(cmd->ofp, "CPU: %d\n", defcpu_ppc64);
	fprintf(cmd->ofp, 
		"NIP: %016"FMTPTR"x  XER: %016"FMTPTR"x LR: %016"FMTPTR"x\n",
		KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].nip),
		KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].xer),
		KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].link));
	msr = KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].msr);
	trap = KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].trap);
	fprintf(cmd->ofp, "TRAP: %04"FMTPTR"x  MSR: %016"FMTPTR"x  EE: %01x  PR: %01x  FP: %01x\n",
		trap, msr, msr&MSR_EE_PPC64 ? 1 : 0,
		msr&MSR_PR_PPC64 ? 1 : 0, msr&MSR_FP_PPC64 ? 1 : 0);
	fprintf(cmd->ofp, "ME: %01x  IR/DR: %01x/%01x\n",
		msr&MSR_ME_PPC64 ? 1 : 0,msr&MSR_IR_PPC64 ? 1 : 0,
		msr&MSR_DR_PPC64 ? 1 : 0);
	if (trap == 0x300 || trap == 0x380 || trap == 0x600)
		fprintf(cmd->ofp,"DAR: %016"FMTPTR"x  DSISR: %016"FMTPTR"x\n",
			KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].dar),
			KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].dsisr));
	for (i = 0; i < 32; i++) {
		if ((i % 2) == 0) {
			fprintf(cmd->ofp, "\n");
		}
		fprintf(cmd->ofp, "  GPR%02d: %016"FMTPTR"x", i, 
			KL_GET_UINT64(&dha.smp_regs[defcpu_ppc64].gpr[i]));
	}
	fprintf(cmd->ofp, "\n\n");
	return(0);
}
