/*
 * $Id: cmd_pci.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003 - 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <lcrash.h>
#include <kl_libhwconfig.h>

/* External function prototypes
 */
void pci_dev_banner(FILE *, int);
int print_pci_dev(pci_dev_t *, FILE *, int);

/*
 * pci_cmd() -- Run the 'pci' command.
 */
int
pci_cmd(command_t *cmd)
{
        pci_dev_t *pci_dev;

        if (kl_init_hwconfig()) {
		return(1);
	}

        if (pci_dev_count) {
                pci_dev = pci_devices;
                pci_dev_banner(cmd->ofp, BANNER|SMAJOR);
                do {
                        print_pci_dev(pci_dev, cmd->ofp, cmd->flags);
                        pci_dev = (pci_dev_t *)pci_dev->g_next;
                } while (pci_dev != pci_devices);
        }
	return(0);
}

#define _PCI_USAGE "[-f] [-w outfile] [pci_list]"

/*
 * pci_usage() -- Print the usage string for the 'pci' command.
 */
void
pci_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _PCI_USAGE);
}

/*
 * pci_help() -- Print the help information for the 'pci' command.
 */
void
pci_help(command_t *cmd)
{
	CMD_HELP(cmd, _PCI_USAGE,
        "Display relevant information for each entry in pci_list. If "
        "no entries are specified, display information for all installed "
        "pci devices.  Entries in pci_list can take the form of a virtual "
	"address for a pci_dev struct.");
}

/*
 * pci_parse() -- Parse the command line arguments for 'pci'.
 */
int
pci_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FULL|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * pci_complete() -- Complete arguments of 'pci' command.
 */
char *
pci_complete(command_t *cmd)
{
        char *ret;

        /* complete standard options (for example, -w option) arguments
         */
        if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
                return(ret);
        }
        fprintf(cmd->ofp, "\n");
        pci_usage(cmd);
        return(DRAW_NEW_ENTIRE_LINE);
}                       
