/*
  File autogenerated by gengetopt version 2.14
  generated with the following command:
  /usr/local/bin/gengetopt 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


char *cmdline_parser_output_character_values[] = {"1", "2", 0} ;	/* Possible values for output-character.  */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->value_given = 0 ;
  args_info->x_given = 0 ;
  args_info->y_given = 0 ;
  args_info->value_file_given = 0 ;
  args_info->value_line_segment_given = 0 ;
  args_info->X_given = 0 ;
  args_info->Y_given = 0 ;
  args_info->number_samples_given = 0 ;
  args_info->zeros_given = 0 ;
  args_info->zeros_interval_given = 0 ;
  args_info->stepsize_given = 0 ;
  args_info->derivative_given = 0 ;
  args_info->elliptic_curve_given = 0 ;
  args_info->a1_given = 0 ;
  args_info->a2_given = 0 ;
  args_info->a3_given = 0 ;
  args_info->a4_given = 0 ;
  args_info->a6_given = 0 ;
  args_info->file_input_given = 0 ;
  args_info->url_given = 0 ;
  args_info->interpolate_given = 0 ;
  args_info->output_character_given = 0 ;
  args_info->output_data_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->precision_given = 0 ;
  args_info->sacrifice_given = 0 ;
  args_info->rank_compute_given = 0 ;
  args_info->rank_verify_given = 0 ;
  args_info->rank_limit_given = 0 ;
  args_info->tau_given = 0 ;
  args_info->twist_quadratic_given = 0 ;
  args_info->start_given = 0 ;
  args_info->finish_given = 0 ;
  args_info->twist_quadratic_even_given = 0 ;
  args_info->twist_primitive_given = 0 ;
  args_info->twist_all_given = 0 ;
  args_info->twist_all_no_conj_pairs_given = 0 ;
  args_info->twist_complex_no_conj_pairs_given = 0 ;
  args_info->twist_generic_given = 0 ;
  args_info->degree_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->value_flag = 0;
  args_info->x_arg = gengetopt_strdup (".5");
  args_info->x_orig = NULL;
  args_info->y_arg = gengetopt_strdup ("0");
  args_info->y_orig = NULL;
  args_info->value_file_arg = NULL;
  args_info->value_file_orig = NULL;
  args_info->value_line_segment_flag = 0;
  args_info->X_arg = gengetopt_strdup (".5");
  args_info->X_orig = NULL;
  args_info->Y_arg = gengetopt_strdup ("100");
  args_info->Y_orig = NULL;
  args_info->number_samples_arg = 1000;
  args_info->number_samples_orig = NULL;
  args_info->zeros_orig = NULL;
  args_info->zeros_interval_flag = 0;
  args_info->stepsize_arg = NULL;
  args_info->stepsize_orig = NULL;
  args_info->derivative_orig = NULL;
  args_info->elliptic_curve_flag = 0;
  args_info->a1_arg = NULL;
  args_info->a1_orig = NULL;
  args_info->a2_arg = NULL;
  args_info->a2_orig = NULL;
  args_info->a3_arg = NULL;
  args_info->a3_orig = NULL;
  args_info->a4_arg = NULL;
  args_info->a4_orig = NULL;
  args_info->a6_arg = NULL;
  args_info->a6_orig = NULL;
  args_info->file_input_arg = NULL;
  args_info->file_input_orig = NULL;
  args_info->url_arg = NULL;
  args_info->url_orig = NULL;
  args_info->interpolate_arg = NULL;
  args_info->interpolate_orig = NULL;
  args_info->output_character_arg = gengetopt_strdup ("1");
  args_info->output_character_orig = NULL;
  args_info->output_data_arg = 10;
  args_info->output_data_orig = NULL;
  args_info->verbose_arg = 0;
  args_info->verbose_orig = NULL;
  args_info->precision_arg = 14;
  args_info->precision_orig = NULL;
  args_info->sacrifice_arg = 2;
  args_info->sacrifice_orig = NULL;
  args_info->rank_compute_flag = 0;
  args_info->rank_verify_orig = NULL;
  args_info->rank_limit_orig = NULL;
  args_info->tau_flag = 0;
  args_info->twist_quadratic_flag = 0;
  args_info->start_arg = NULL;
  args_info->start_orig = NULL;
  args_info->finish_arg = NULL;
  args_info->finish_orig = NULL;
  args_info->twist_quadratic_even_flag = 0;
  args_info->twist_primitive_flag = 0;
  args_info->twist_all_flag = 0;
  args_info->twist_all_no_conj_pairs_flag = 0;
  args_info->twist_complex_no_conj_pairs_flag = 0;
  args_info->twist_generic_flag = 0;
  args_info->degree_orig = NULL;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "This program computes zeros and values of L-function.");
  printf("\nUsage: lcalc [OPTIONS]...\n\n");
  printf("%s\n","  -h, --help                    Print help and exit");
  printf("%s\n","  -V, --version                 Print version and exit");
  printf("%s\n","  -v, --value                   compute L-function at x+iy. Should be used in \n                                  conjuction with x and y options  \n                                  (default=off)");
  printf("%s\n","  -x, --x=Double                Used with value,value-line-segment, and \n                                  zeros-interval options  (default=`.5')");
  printf("%s\n","  -y, --y=Double                Used with value,value-line-segment, and \n                                  zeros-interval options  (default=`0')");
  printf("%s\n","      --value-file=filename     compute L-function at points specified in file");
  printf("%s\n","      --value-line-segment      compute L-function along a line segment \n                                  connecting (x,y) to (X,Y) at number-sample \n                                  points  (default=off)");
  printf("%s\n","  -X, --X=Double                Used with value-line-segment  (default=`.5')");
  printf("%s\n","  -Y, --Y=Double                Used with value-line-segment  (default=`100')");
  printf("%s\n","  -n, --number-samples=INT      Used with value-line-segment, and interpolate \n                                  options  (default=`1000')");
  printf("%s\n","  -z, --zeros=INT               number of zeros to find");
  printf("%s\n","  -Z, --zeros-interval          number of zeros to find in an interval \n                                  (1/2+ix,1/2+iy) using steps of size stepsize. \n                                  Use with the x,y, and stepsize options  \n                                  (default=off)");
  printf("%s\n","      --stepsize=Double         Used with zeros-interval");
  printf("%s\n","  -d, --derivative=INT          compute derivative. use -d -1 to specify \n                                  logarithmic derivative.");
  printf("%s\n","  -e, --elliptic-curve          specify an elliptic curve over Q. Use with the \n                                  a1 a2 a3 a4 a6 options  (default=off)");
  printf("%s\n","      --a1=rational_number      Used with the elliptic-curve option");
  printf("%s\n","      --a2=rational_number      Used with the elliptic-curve option");
  printf("%s\n","      --a3=rational_number      Used with the elliptic-curve option");
  printf("%s\n","      --a4=rational_number      Used with the elliptic-curve option");
  printf("%s\n","      --a6=rational_number      Used with the elliptic-curve option");
  printf("%s\n","  -F, --file-input=filename     input a file with basic L-function data");
  printf("%s\n","  -u, --url=url                 input a web based file with basic L-function \n                                  data. Specify the url of the file");
  printf("%s\n","  -i, --interpolate=filename2   interpolate between two L-functions and find \n                                  their zeros. Should be used in conjunction \n                                  with file-input");
  printf("%s\n","  -C, --output-character=STRING if twisting, output the character  (possible \n                                  values=\"1\", \"2\" default=`1')");
  printf("%s\n","  -o, --output-data=number Dirichlet coeffs\n                                output basic data for the underlying L-function \n                                   (default=`10')");
  printf("%s\n","      --verbose=INT             verbosity > 0 outputs extra info  (default=`0')");
  printf("%s\n","  -P, --precision=INT           number digits precision  (default=`14')");
  printf("%s\n","  -S, --sacrifice=INT           number digits to sacrifice  (default=`2')");
  printf("%s\n","  -r, --rank-compute            compute the rank  (default=off)");
  printf("%s\n","      --rank-verify=INT         verify if specified rank is correct");
  printf("%s\n","  -l, --rank-limit=INT          when doing quadratic twists limit to \n                                  L-functions with specified rank");
  printf("%s\n","  -t, --tau                     Ramanujan tau L-function (weight 12, full \n                                  level)  (default=off)");
  printf("%s\n","  -q, --twist-quadratic         twist by fundamental quadratic characters, \n                                  start <= discriminant <= finish. Use with \n                                  start and finish options.  (default=off)");
  printf("%s\n","  -s, --start=integer           Used with various twisting options");
  printf("%s\n","  -f, --finish=integer          Used with various twisting options. Default has \n                                  finish=start");
  printf("%s\n","      --twist-quadratic-even    twist by fundamental quadratic characters, even \n                                  functional eqn, start <= discriminant <= \n                                  finish  (default=off)");
  printf("%s\n","  -p, --twist-primitive         twist by all primitive Dirichlet characters \n                                  with start <= conductor <= finish. For \n                                  L-functions with complex Dirichlet \n                                  coefficients, conjugate characters are \n                                  considered equaivalent  (default=off)");
  printf("%s\n","  -A, --twist-all               twist by all Dirichlet characters with start <= \n                                  conductor <= finish.  (default=off)");
  printf("%s\n","  -a, --twist-all-no-conj-pairs twist by all Dirichlet characters with start <= \n                                  conductor <= finish. For L-functions with \n                                  complex Dirichlet coefficients, conjugate \n                                  pairs of characters are considered equivalent \n                                   (default=off)");
  printf("%s\n","  -c, --twist-complex-no-conj-pairs\n                                twist by all complex primitive Dirichlet \n                                  characters with start <= conductor <= finish. \n                                  For L-functions with complex Dirichlet \n                                  coefficients, conjugate pairs of characters \n                                  are considered equivalent  (default=off)");
  printf("%s\n","  -g, --twist-generic           twist by a generic complex Dirichlet characters \n                                  with start <= conductor <= finish.  \n                                  (default=off)");
  printf("%s\n","  -D, --degree=degree           can only be used in conjuction with \n                                  twist-primitive (?). Select characters of \n                                  specified degree. Not yet implemented");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  if (args_info->x_arg)
    {
      free (args_info->x_arg); /* free previous argument */
      args_info->x_arg = 0;
    }
  if (args_info->x_orig)
    {
      free (args_info->x_orig); /* free previous argument */
      args_info->x_orig = 0;
    }
  if (args_info->y_arg)
    {
      free (args_info->y_arg); /* free previous argument */
      args_info->y_arg = 0;
    }
  if (args_info->y_orig)
    {
      free (args_info->y_orig); /* free previous argument */
      args_info->y_orig = 0;
    }
  if (args_info->value_file_arg)
    {
      free (args_info->value_file_arg); /* free previous argument */
      args_info->value_file_arg = 0;
    }
  if (args_info->value_file_orig)
    {
      free (args_info->value_file_orig); /* free previous argument */
      args_info->value_file_orig = 0;
    }
  if (args_info->X_arg)
    {
      free (args_info->X_arg); /* free previous argument */
      args_info->X_arg = 0;
    }
  if (args_info->X_orig)
    {
      free (args_info->X_orig); /* free previous argument */
      args_info->X_orig = 0;
    }
  if (args_info->Y_arg)
    {
      free (args_info->Y_arg); /* free previous argument */
      args_info->Y_arg = 0;
    }
  if (args_info->Y_orig)
    {
      free (args_info->Y_orig); /* free previous argument */
      args_info->Y_orig = 0;
    }
  if (args_info->number_samples_orig)
    {
      free (args_info->number_samples_orig); /* free previous argument */
      args_info->number_samples_orig = 0;
    }
  if (args_info->zeros_orig)
    {
      free (args_info->zeros_orig); /* free previous argument */
      args_info->zeros_orig = 0;
    }
  if (args_info->stepsize_arg)
    {
      free (args_info->stepsize_arg); /* free previous argument */
      args_info->stepsize_arg = 0;
    }
  if (args_info->stepsize_orig)
    {
      free (args_info->stepsize_orig); /* free previous argument */
      args_info->stepsize_orig = 0;
    }
  if (args_info->derivative_orig)
    {
      free (args_info->derivative_orig); /* free previous argument */
      args_info->derivative_orig = 0;
    }
  if (args_info->a1_arg)
    {
      free (args_info->a1_arg); /* free previous argument */
      args_info->a1_arg = 0;
    }
  if (args_info->a1_orig)
    {
      free (args_info->a1_orig); /* free previous argument */
      args_info->a1_orig = 0;
    }
  if (args_info->a2_arg)
    {
      free (args_info->a2_arg); /* free previous argument */
      args_info->a2_arg = 0;
    }
  if (args_info->a2_orig)
    {
      free (args_info->a2_orig); /* free previous argument */
      args_info->a2_orig = 0;
    }
  if (args_info->a3_arg)
    {
      free (args_info->a3_arg); /* free previous argument */
      args_info->a3_arg = 0;
    }
  if (args_info->a3_orig)
    {
      free (args_info->a3_orig); /* free previous argument */
      args_info->a3_orig = 0;
    }
  if (args_info->a4_arg)
    {
      free (args_info->a4_arg); /* free previous argument */
      args_info->a4_arg = 0;
    }
  if (args_info->a4_orig)
    {
      free (args_info->a4_orig); /* free previous argument */
      args_info->a4_orig = 0;
    }
  if (args_info->a6_arg)
    {
      free (args_info->a6_arg); /* free previous argument */
      args_info->a6_arg = 0;
    }
  if (args_info->a6_orig)
    {
      free (args_info->a6_orig); /* free previous argument */
      args_info->a6_orig = 0;
    }
  if (args_info->file_input_arg)
    {
      free (args_info->file_input_arg); /* free previous argument */
      args_info->file_input_arg = 0;
    }
  if (args_info->file_input_orig)
    {
      free (args_info->file_input_orig); /* free previous argument */
      args_info->file_input_orig = 0;
    }
  if (args_info->url_arg)
    {
      free (args_info->url_arg); /* free previous argument */
      args_info->url_arg = 0;
    }
  if (args_info->url_orig)
    {
      free (args_info->url_orig); /* free previous argument */
      args_info->url_orig = 0;
    }
  if (args_info->interpolate_arg)
    {
      free (args_info->interpolate_arg); /* free previous argument */
      args_info->interpolate_arg = 0;
    }
  if (args_info->interpolate_orig)
    {
      free (args_info->interpolate_orig); /* free previous argument */
      args_info->interpolate_orig = 0;
    }
  if (args_info->output_character_arg)
    {
      free (args_info->output_character_arg); /* free previous argument */
      args_info->output_character_arg = 0;
    }
  if (args_info->output_character_orig)
    {
      free (args_info->output_character_orig); /* free previous argument */
      args_info->output_character_orig = 0;
    }
  if (args_info->output_data_orig)
    {
      free (args_info->output_data_orig); /* free previous argument */
      args_info->output_data_orig = 0;
    }
  if (args_info->verbose_orig)
    {
      free (args_info->verbose_orig); /* free previous argument */
      args_info->verbose_orig = 0;
    }
  if (args_info->precision_orig)
    {
      free (args_info->precision_orig); /* free previous argument */
      args_info->precision_orig = 0;
    }
  if (args_info->sacrifice_orig)
    {
      free (args_info->sacrifice_orig); /* free previous argument */
      args_info->sacrifice_orig = 0;
    }
  if (args_info->rank_verify_orig)
    {
      free (args_info->rank_verify_orig); /* free previous argument */
      args_info->rank_verify_orig = 0;
    }
  if (args_info->rank_limit_orig)
    {
      free (args_info->rank_limit_orig); /* free previous argument */
      args_info->rank_limit_orig = 0;
    }
  if (args_info->start_arg)
    {
      free (args_info->start_arg); /* free previous argument */
      args_info->start_arg = 0;
    }
  if (args_info->start_orig)
    {
      free (args_info->start_orig); /* free previous argument */
      args_info->start_orig = 0;
    }
  if (args_info->finish_arg)
    {
      free (args_info->finish_arg); /* free previous argument */
      args_info->finish_arg = 0;
    }
  if (args_info->finish_orig)
    {
      free (args_info->finish_orig); /* free previous argument */
      args_info->finish_orig = 0;
    }
  if (args_info->degree_orig)
    {
      free (args_info->degree_orig); /* free previous argument */
      args_info->degree_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->value_given) {
    fprintf(outfile, "%s\n", "value");
  }
  if (args_info->x_given) {
    if (args_info->x_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "x", args_info->x_orig);
    } else {
      fprintf(outfile, "%s\n", "x");
    }
  }
  if (args_info->y_given) {
    if (args_info->y_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "y", args_info->y_orig);
    } else {
      fprintf(outfile, "%s\n", "y");
    }
  }
  if (args_info->value_file_given) {
    if (args_info->value_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "value-file", args_info->value_file_orig);
    } else {
      fprintf(outfile, "%s\n", "value-file");
    }
  }
  if (args_info->value_line_segment_given) {
    fprintf(outfile, "%s\n", "value-line-segment");
  }
  if (args_info->X_given) {
    if (args_info->X_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "X", args_info->X_orig);
    } else {
      fprintf(outfile, "%s\n", "X");
    }
  }
  if (args_info->Y_given) {
    if (args_info->Y_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "Y", args_info->Y_orig);
    } else {
      fprintf(outfile, "%s\n", "Y");
    }
  }
  if (args_info->number_samples_given) {
    if (args_info->number_samples_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "number-samples", args_info->number_samples_orig);
    } else {
      fprintf(outfile, "%s\n", "number-samples");
    }
  }
  if (args_info->zeros_given) {
    if (args_info->zeros_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "zeros", args_info->zeros_orig);
    } else {
      fprintf(outfile, "%s\n", "zeros");
    }
  }
  if (args_info->zeros_interval_given) {
    fprintf(outfile, "%s\n", "zeros-interval");
  }
  if (args_info->stepsize_given) {
    if (args_info->stepsize_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "stepsize", args_info->stepsize_orig);
    } else {
      fprintf(outfile, "%s\n", "stepsize");
    }
  }
  if (args_info->derivative_given) {
    if (args_info->derivative_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "derivative", args_info->derivative_orig);
    } else {
      fprintf(outfile, "%s\n", "derivative");
    }
  }
  if (args_info->elliptic_curve_given) {
    fprintf(outfile, "%s\n", "elliptic-curve");
  }
  if (args_info->a1_given) {
    if (args_info->a1_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "a1", args_info->a1_orig);
    } else {
      fprintf(outfile, "%s\n", "a1");
    }
  }
  if (args_info->a2_given) {
    if (args_info->a2_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "a2", args_info->a2_orig);
    } else {
      fprintf(outfile, "%s\n", "a2");
    }
  }
  if (args_info->a3_given) {
    if (args_info->a3_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "a3", args_info->a3_orig);
    } else {
      fprintf(outfile, "%s\n", "a3");
    }
  }
  if (args_info->a4_given) {
    if (args_info->a4_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "a4", args_info->a4_orig);
    } else {
      fprintf(outfile, "%s\n", "a4");
    }
  }
  if (args_info->a6_given) {
    if (args_info->a6_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "a6", args_info->a6_orig);
    } else {
      fprintf(outfile, "%s\n", "a6");
    }
  }
  if (args_info->file_input_given) {
    if (args_info->file_input_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "file-input", args_info->file_input_orig);
    } else {
      fprintf(outfile, "%s\n", "file-input");
    }
  }
  if (args_info->url_given) {
    if (args_info->url_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "url", args_info->url_orig);
    } else {
      fprintf(outfile, "%s\n", "url");
    }
  }
  if (args_info->interpolate_given) {
    if (args_info->interpolate_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "interpolate", args_info->interpolate_orig);
    } else {
      fprintf(outfile, "%s\n", "interpolate");
    }
  }
  if (args_info->output_character_given) {
    if (args_info->output_character_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "output-character", args_info->output_character_orig);
    } else {
      fprintf(outfile, "%s\n", "output-character");
    }
  }
  if (args_info->output_data_given) {
    if (args_info->output_data_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "output-data", args_info->output_data_orig);
    } else {
      fprintf(outfile, "%s\n", "output-data");
    }
  }
  if (args_info->verbose_given) {
    if (args_info->verbose_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "verbose", args_info->verbose_orig);
    } else {
      fprintf(outfile, "%s\n", "verbose");
    }
  }
  if (args_info->precision_given) {
    if (args_info->precision_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "precision", args_info->precision_orig);
    } else {
      fprintf(outfile, "%s\n", "precision");
    }
  }
  if (args_info->sacrifice_given) {
    if (args_info->sacrifice_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "sacrifice", args_info->sacrifice_orig);
    } else {
      fprintf(outfile, "%s\n", "sacrifice");
    }
  }
  if (args_info->rank_compute_given) {
    fprintf(outfile, "%s\n", "rank-compute");
  }
  if (args_info->rank_verify_given) {
    if (args_info->rank_verify_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "rank-verify", args_info->rank_verify_orig);
    } else {
      fprintf(outfile, "%s\n", "rank-verify");
    }
  }
  if (args_info->rank_limit_given) {
    if (args_info->rank_limit_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "rank-limit", args_info->rank_limit_orig);
    } else {
      fprintf(outfile, "%s\n", "rank-limit");
    }
  }
  if (args_info->tau_given) {
    fprintf(outfile, "%s\n", "tau");
  }
  if (args_info->twist_quadratic_given) {
    fprintf(outfile, "%s\n", "twist-quadratic");
  }
  if (args_info->start_given) {
    if (args_info->start_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "start", args_info->start_orig);
    } else {
      fprintf(outfile, "%s\n", "start");
    }
  }
  if (args_info->finish_given) {
    if (args_info->finish_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "finish", args_info->finish_orig);
    } else {
      fprintf(outfile, "%s\n", "finish");
    }
  }
  if (args_info->twist_quadratic_even_given) {
    fprintf(outfile, "%s\n", "twist-quadratic-even");
  }
  if (args_info->twist_primitive_given) {
    fprintf(outfile, "%s\n", "twist-primitive");
  }
  if (args_info->twist_all_given) {
    fprintf(outfile, "%s\n", "twist-all");
  }
  if (args_info->twist_all_no_conj_pairs_given) {
    fprintf(outfile, "%s\n", "twist-all-no-conj-pairs");
  }
  if (args_info->twist_complex_no_conj_pairs_given) {
    fprintf(outfile, "%s\n", "twist-complex-no-conj-pairs");
  }
  if (args_info->twist_generic_given) {
    fprintf(outfile, "%s\n", "twist-generic");
  }
  if (args_info->degree_given) {
    if (args_info->degree_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "degree", args_info->degree_orig);
    } else {
      fprintf(outfile, "%s\n", "degree");
    }
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

static int
check_possible_values(const char *val, char *values[])
{
  int i, found;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return 0; /* NULL means no argument for the option */

  for (found = i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          found++;
          if (strlen(values[i]) == len)
            return 1; /* exact macth no need to check more */
        }
    }

  return found; /* return how many values are matched */
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int found = 0;
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "value",	0, NULL, 'v' },
        { "x",	1, NULL, 'x' },
        { "y",	1, NULL, 'y' },
        { "value-file",	1, NULL, 0 },
        { "value-line-segment",	0, NULL, 0 },
        { "X",	1, NULL, 'X' },
        { "Y",	1, NULL, 'Y' },
        { "number-samples",	1, NULL, 'n' },
        { "zeros",	1, NULL, 'z' },
        { "zeros-interval",	0, NULL, 'Z' },
        { "stepsize",	1, NULL, 0 },
        { "derivative",	1, NULL, 'd' },
        { "elliptic-curve",	0, NULL, 'e' },
        { "a1",	1, NULL, 0 },
        { "a2",	1, NULL, 0 },
        { "a3",	1, NULL, 0 },
        { "a4",	1, NULL, 0 },
        { "a6",	1, NULL, 0 },
        { "file-input",	1, NULL, 'F' },
        { "url",	1, NULL, 'u' },
        { "interpolate",	1, NULL, 'i' },
        { "output-character",	1, NULL, 'C' },
        { "output-data",	1, NULL, 'o' },
        { "verbose",	1, NULL, 0 },
        { "precision",	1, NULL, 'P' },
        { "sacrifice",	1, NULL, 'S' },
        { "rank-compute",	0, NULL, 'r' },
        { "rank-verify",	1, NULL, 0 },
        { "rank-limit",	1, NULL, 'l' },
        { "tau",	0, NULL, 't' },
        { "twist-quadratic",	0, NULL, 'q' },
        { "start",	1, NULL, 's' },
        { "finish",	1, NULL, 'f' },
        { "twist-quadratic-even",	0, NULL, 0 },
        { "twist-primitive",	0, NULL, 'p' },
        { "twist-all",	0, NULL, 'A' },
        { "twist-all-no-conj-pairs",	0, NULL, 'a' },
        { "twist-complex-no-conj-pairs",	0, NULL, 'c' },
        { "twist-generic",	0, NULL, 'g' },
        { "degree",	1, NULL, 'D' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVvx:y:X:Y:n:z:Zd:eF:u:i:C:o:P:S:rl:tqs:f:pAacgD:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* compute L-function at x+iy. Should be used in conjuction with x and y options.  */
          if (local_args_info.value_given)
            {
              fprintf (stderr, "%s: `--value' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->value_given && ! override)
            continue;
          local_args_info.value_given = 1;
          args_info->value_given = 1;
          args_info->value_flag = !(args_info->value_flag);
          break;

        case 'x':	/* Used with value,value-line-segment, and zeros-interval options.  */
          if (local_args_info.x_given)
            {
              fprintf (stderr, "%s: `--x' (`-x') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->x_given && ! override)
            continue;
          local_args_info.x_given = 1;
          args_info->x_given = 1;
          if (args_info->x_arg)
            free (args_info->x_arg); /* free previous string */
          args_info->x_arg = gengetopt_strdup (optarg);
          if (args_info->x_orig)
            free (args_info->x_orig); /* free previous string */
          args_info->x_orig = gengetopt_strdup (optarg);
          break;

        case 'y':	/* Used with value,value-line-segment, and zeros-interval options.  */
          if (local_args_info.y_given)
            {
              fprintf (stderr, "%s: `--y' (`-y') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->y_given && ! override)
            continue;
          local_args_info.y_given = 1;
          args_info->y_given = 1;
          if (args_info->y_arg)
            free (args_info->y_arg); /* free previous string */
          args_info->y_arg = gengetopt_strdup (optarg);
          if (args_info->y_orig)
            free (args_info->y_orig); /* free previous string */
          args_info->y_orig = gengetopt_strdup (optarg);
          break;

        case 'X':	/* Used with value-line-segment.  */
          if (local_args_info.X_given)
            {
              fprintf (stderr, "%s: `--X' (`-X') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->X_given && ! override)
            continue;
          local_args_info.X_given = 1;
          args_info->X_given = 1;
          if (args_info->X_arg)
            free (args_info->X_arg); /* free previous string */
          args_info->X_arg = gengetopt_strdup (optarg);
          if (args_info->X_orig)
            free (args_info->X_orig); /* free previous string */
          args_info->X_orig = gengetopt_strdup (optarg);
          break;

        case 'Y':	/* Used with value-line-segment.  */
          if (local_args_info.Y_given)
            {
              fprintf (stderr, "%s: `--Y' (`-Y') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->Y_given && ! override)
            continue;
          local_args_info.Y_given = 1;
          args_info->Y_given = 1;
          if (args_info->Y_arg)
            free (args_info->Y_arg); /* free previous string */
          args_info->Y_arg = gengetopt_strdup (optarg);
          if (args_info->Y_orig)
            free (args_info->Y_orig); /* free previous string */
          args_info->Y_orig = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Used with value-line-segment, and interpolate options.  */
          if (local_args_info.number_samples_given)
            {
              fprintf (stderr, "%s: `--number-samples' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->number_samples_given && ! override)
            continue;
          local_args_info.number_samples_given = 1;
          args_info->number_samples_given = 1;
          args_info->number_samples_arg = strtol (optarg,&stop_char,0);
          if (args_info->number_samples_orig)
            free (args_info->number_samples_orig); /* free previous string */
          args_info->number_samples_orig = gengetopt_strdup (optarg);
          break;

        case 'z':	/* number of zeros to find.  */
          if (local_args_info.zeros_given)
            {
              fprintf (stderr, "%s: `--zeros' (`-z') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->zeros_given && ! override)
            continue;
          local_args_info.zeros_given = 1;
          args_info->zeros_given = 1;
          args_info->zeros_arg = strtol (optarg,&stop_char,0);
          if (args_info->zeros_orig)
            free (args_info->zeros_orig); /* free previous string */
          args_info->zeros_orig = gengetopt_strdup (optarg);
          break;

        case 'Z':	/* number of zeros to find in an interval (1/2+ix,1/2+iy) using steps of size stepsize. Use with the x,y, and stepsize options.  */
          if (local_args_info.zeros_interval_given)
            {
              fprintf (stderr, "%s: `--zeros-interval' (`-Z') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->zeros_interval_given && ! override)
            continue;
          local_args_info.zeros_interval_given = 1;
          args_info->zeros_interval_given = 1;
          args_info->zeros_interval_flag = !(args_info->zeros_interval_flag);
          break;

        case 'd':	/* compute derivative. use -d -1 to specify logarithmic derivative..  */
          if (local_args_info.derivative_given)
            {
              fprintf (stderr, "%s: `--derivative' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->derivative_given && ! override)
            continue;
          local_args_info.derivative_given = 1;
          args_info->derivative_given = 1;
          args_info->derivative_arg = strtol (optarg,&stop_char,0);
          if (args_info->derivative_orig)
            free (args_info->derivative_orig); /* free previous string */
          args_info->derivative_orig = gengetopt_strdup (optarg);
          break;

        case 'e':	/* specify an elliptic curve over Q. Use with the a1 a2 a3 a4 a6 options.  */
          if (local_args_info.elliptic_curve_given)
            {
              fprintf (stderr, "%s: `--elliptic-curve' (`-e') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->elliptic_curve_given && ! override)
            continue;
          local_args_info.elliptic_curve_given = 1;
          args_info->elliptic_curve_given = 1;
          args_info->elliptic_curve_flag = !(args_info->elliptic_curve_flag);
          break;

        case 'F':	/* input a file with basic L-function data.  */
          if (local_args_info.file_input_given)
            {
              fprintf (stderr, "%s: `--file-input' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->file_input_given && ! override)
            continue;
          local_args_info.file_input_given = 1;
          args_info->file_input_given = 1;
          if (args_info->file_input_arg)
            free (args_info->file_input_arg); /* free previous string */
          args_info->file_input_arg = gengetopt_strdup (optarg);
          if (args_info->file_input_orig)
            free (args_info->file_input_orig); /* free previous string */
          args_info->file_input_orig = gengetopt_strdup (optarg);
          break;

        case 'u':	/* input a web based file with basic L-function data. Specify the url of the file.  */
          if (local_args_info.url_given)
            {
              fprintf (stderr, "%s: `--url' (`-u') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->url_given && ! override)
            continue;
          local_args_info.url_given = 1;
          args_info->url_given = 1;
          if (args_info->url_arg)
            free (args_info->url_arg); /* free previous string */
          args_info->url_arg = gengetopt_strdup (optarg);
          if (args_info->url_orig)
            free (args_info->url_orig); /* free previous string */
          args_info->url_orig = gengetopt_strdup (optarg);
          break;

        case 'i':	/* interpolate between two L-functions and find their zeros. Should be used in conjunction with file-input.  */
          if (local_args_info.interpolate_given)
            {
              fprintf (stderr, "%s: `--interpolate' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->interpolate_given && ! override)
            continue;
          local_args_info.interpolate_given = 1;
          args_info->interpolate_given = 1;
          if (args_info->interpolate_arg)
            free (args_info->interpolate_arg); /* free previous string */
          args_info->interpolate_arg = gengetopt_strdup (optarg);
          if (args_info->interpolate_orig)
            free (args_info->interpolate_orig); /* free previous string */
          args_info->interpolate_orig = gengetopt_strdup (optarg);
          break;

        case 'C':	/* if twisting, output the character.  */
          if (local_args_info.output_character_given)
            {
              fprintf (stderr, "%s: `--output-character' (`-C') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if ((found = check_possible_values(optarg, cmdline_parser_output_character_values)) != 1)
            {
              fprintf (stderr, "%s: %s argument, \"%s\", for option `--output-character' (`-C')%s\n", argv[0], found ? "ambiguous" : "invalid", optarg, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->output_character_given && ! override)
            continue;
          local_args_info.output_character_given = 1;
          args_info->output_character_given = 1;
          if (args_info->output_character_arg)
            free (args_info->output_character_arg); /* free previous string */
          args_info->output_character_arg = gengetopt_strdup (optarg);
          if (args_info->output_character_orig)
            free (args_info->output_character_orig); /* free previous string */
          args_info->output_character_orig = gengetopt_strdup (optarg);
          break;

        case 'o':	/* output basic data for the underlying L-function.  */
          if (local_args_info.output_data_given)
            {
              fprintf (stderr, "%s: `--output-data' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->output_data_given && ! override)
            continue;
          local_args_info.output_data_given = 1;
          args_info->output_data_given = 1;
          args_info->output_data_arg = strtol (optarg,&stop_char,0);
          if (args_info->output_data_orig)
            free (args_info->output_data_orig); /* free previous string */
          args_info->output_data_orig = gengetopt_strdup (optarg);
          break;

        case 'P':	/* number digits precision.  */
          if (local_args_info.precision_given)
            {
              fprintf (stderr, "%s: `--precision' (`-P') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->precision_given && ! override)
            continue;
          local_args_info.precision_given = 1;
          args_info->precision_given = 1;
          args_info->precision_arg = strtol (optarg,&stop_char,0);
          if (args_info->precision_orig)
            free (args_info->precision_orig); /* free previous string */
          args_info->precision_orig = gengetopt_strdup (optarg);
          break;

        case 'S':	/* number digits to sacrifice.  */
          if (local_args_info.sacrifice_given)
            {
              fprintf (stderr, "%s: `--sacrifice' (`-S') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->sacrifice_given && ! override)
            continue;
          local_args_info.sacrifice_given = 1;
          args_info->sacrifice_given = 1;
          args_info->sacrifice_arg = strtol (optarg,&stop_char,0);
          if (args_info->sacrifice_orig)
            free (args_info->sacrifice_orig); /* free previous string */
          args_info->sacrifice_orig = gengetopt_strdup (optarg);
          break;

        case 'r':	/* compute the rank.  */
          if (local_args_info.rank_compute_given)
            {
              fprintf (stderr, "%s: `--rank-compute' (`-r') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->rank_compute_given && ! override)
            continue;
          local_args_info.rank_compute_given = 1;
          args_info->rank_compute_given = 1;
          args_info->rank_compute_flag = !(args_info->rank_compute_flag);
          break;

        case 'l':	/* when doing quadratic twists limit to L-functions with specified rank.  */
          if (local_args_info.rank_limit_given)
            {
              fprintf (stderr, "%s: `--rank-limit' (`-l') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->rank_limit_given && ! override)
            continue;
          local_args_info.rank_limit_given = 1;
          args_info->rank_limit_given = 1;
          args_info->rank_limit_arg = strtol (optarg,&stop_char,0);
          if (args_info->rank_limit_orig)
            free (args_info->rank_limit_orig); /* free previous string */
          args_info->rank_limit_orig = gengetopt_strdup (optarg);
          break;

        case 't':	/* Ramanujan tau L-function (weight 12, full level).  */
          if (local_args_info.tau_given)
            {
              fprintf (stderr, "%s: `--tau' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->tau_given && ! override)
            continue;
          local_args_info.tau_given = 1;
          args_info->tau_given = 1;
          args_info->tau_flag = !(args_info->tau_flag);
          break;

        case 'q':	/* twist by fundamental quadratic characters, start <= discriminant <= finish. Use with start and finish options..  */
          if (local_args_info.twist_quadratic_given)
            {
              fprintf (stderr, "%s: `--twist-quadratic' (`-q') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_quadratic_given && ! override)
            continue;
          local_args_info.twist_quadratic_given = 1;
          args_info->twist_quadratic_given = 1;
          args_info->twist_quadratic_flag = !(args_info->twist_quadratic_flag);
          break;

        case 's':	/* Used with various twisting options.  */
          if (local_args_info.start_given)
            {
              fprintf (stderr, "%s: `--start' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->start_given && ! override)
            continue;
          local_args_info.start_given = 1;
          args_info->start_given = 1;
          if (args_info->start_arg)
            free (args_info->start_arg); /* free previous string */
          args_info->start_arg = gengetopt_strdup (optarg);
          if (args_info->start_orig)
            free (args_info->start_orig); /* free previous string */
          args_info->start_orig = gengetopt_strdup (optarg);
          break;

        case 'f':	/* Used with various twisting options. Default has finish=start.  */
          if (local_args_info.finish_given)
            {
              fprintf (stderr, "%s: `--finish' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->finish_given && ! override)
            continue;
          local_args_info.finish_given = 1;
          args_info->finish_given = 1;
          if (args_info->finish_arg)
            free (args_info->finish_arg); /* free previous string */
          args_info->finish_arg = gengetopt_strdup (optarg);
          if (args_info->finish_orig)
            free (args_info->finish_orig); /* free previous string */
          args_info->finish_orig = gengetopt_strdup (optarg);
          break;

        case 'p':	/* twist by all primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate characters are considered equaivalent.  */
          if (local_args_info.twist_primitive_given)
            {
              fprintf (stderr, "%s: `--twist-primitive' (`-p') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_primitive_given && ! override)
            continue;
          local_args_info.twist_primitive_given = 1;
          args_info->twist_primitive_given = 1;
          args_info->twist_primitive_flag = !(args_info->twist_primitive_flag);
          break;

        case 'A':	/* twist by all Dirichlet characters with start <= conductor <= finish..  */
          if (local_args_info.twist_all_given)
            {
              fprintf (stderr, "%s: `--twist-all' (`-A') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_all_given && ! override)
            continue;
          local_args_info.twist_all_given = 1;
          args_info->twist_all_given = 1;
          args_info->twist_all_flag = !(args_info->twist_all_flag);
          break;

        case 'a':	/* twist by all Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent.  */
          if (local_args_info.twist_all_no_conj_pairs_given)
            {
              fprintf (stderr, "%s: `--twist-all-no-conj-pairs' (`-a') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_all_no_conj_pairs_given && ! override)
            continue;
          local_args_info.twist_all_no_conj_pairs_given = 1;
          args_info->twist_all_no_conj_pairs_given = 1;
          args_info->twist_all_no_conj_pairs_flag = !(args_info->twist_all_no_conj_pairs_flag);
          break;

        case 'c':	/* twist by all complex primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent.  */
          if (local_args_info.twist_complex_no_conj_pairs_given)
            {
              fprintf (stderr, "%s: `--twist-complex-no-conj-pairs' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_complex_no_conj_pairs_given && ! override)
            continue;
          local_args_info.twist_complex_no_conj_pairs_given = 1;
          args_info->twist_complex_no_conj_pairs_given = 1;
          args_info->twist_complex_no_conj_pairs_flag = !(args_info->twist_complex_no_conj_pairs_flag);
          break;

        case 'g':	/* twist by a generic complex Dirichlet characters with start <= conductor <= finish..  */
          if (local_args_info.twist_generic_given)
            {
              fprintf (stderr, "%s: `--twist-generic' (`-g') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->twist_generic_given && ! override)
            continue;
          local_args_info.twist_generic_given = 1;
          args_info->twist_generic_given = 1;
          args_info->twist_generic_flag = !(args_info->twist_generic_flag);
          break;

        case 'D':	/* can only be used in conjuction with twist-primitive (?). Select characters of specified degree. Not yet implemented.  */
          if (local_args_info.degree_given)
            {
              fprintf (stderr, "%s: `--degree' (`-D') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->degree_given && ! override)
            continue;
          local_args_info.degree_given = 1;
          args_info->degree_given = 1;
          args_info->degree_arg = strtol (optarg,&stop_char,0);
          if (args_info->degree_orig)
            free (args_info->degree_orig); /* free previous string */
          args_info->degree_orig = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* compute L-function at points specified in file.  */
          if (strcmp (long_options[option_index].name, "value-file") == 0)
          {
            if (local_args_info.value_file_given)
              {
                fprintf (stderr, "%s: `--value-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->value_file_given && ! override)
              continue;
            local_args_info.value_file_given = 1;
            args_info->value_file_given = 1;
            if (args_info->value_file_arg)
              free (args_info->value_file_arg); /* free previous string */
            args_info->value_file_arg = gengetopt_strdup (optarg);
            if (args_info->value_file_orig)
              free (args_info->value_file_orig); /* free previous string */
            args_info->value_file_orig = gengetopt_strdup (optarg);
          }
          /* compute L-function along a line segment connecting (x,y) to (X,Y) at number-sample points.  */
          else if (strcmp (long_options[option_index].name, "value-line-segment") == 0)
          {
            if (local_args_info.value_line_segment_given)
              {
                fprintf (stderr, "%s: `--value-line-segment' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->value_line_segment_given && ! override)
              continue;
            local_args_info.value_line_segment_given = 1;
            args_info->value_line_segment_given = 1;
            args_info->value_line_segment_flag = !(args_info->value_line_segment_flag);
          }
          /* Used with zeros-interval.  */
          else if (strcmp (long_options[option_index].name, "stepsize") == 0)
          {
            if (local_args_info.stepsize_given)
              {
                fprintf (stderr, "%s: `--stepsize' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->stepsize_given && ! override)
              continue;
            local_args_info.stepsize_given = 1;
            args_info->stepsize_given = 1;
            if (args_info->stepsize_arg)
              free (args_info->stepsize_arg); /* free previous string */
            args_info->stepsize_arg = gengetopt_strdup (optarg);
            if (args_info->stepsize_orig)
              free (args_info->stepsize_orig); /* free previous string */
            args_info->stepsize_orig = gengetopt_strdup (optarg);
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a1") == 0)
          {
            if (local_args_info.a1_given)
              {
                fprintf (stderr, "%s: `--a1' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->a1_given && ! override)
              continue;
            local_args_info.a1_given = 1;
            args_info->a1_given = 1;
            if (args_info->a1_arg)
              free (args_info->a1_arg); /* free previous string */
            args_info->a1_arg = gengetopt_strdup (optarg);
            if (args_info->a1_orig)
              free (args_info->a1_orig); /* free previous string */
            args_info->a1_orig = gengetopt_strdup (optarg);
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a2") == 0)
          {
            if (local_args_info.a2_given)
              {
                fprintf (stderr, "%s: `--a2' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->a2_given && ! override)
              continue;
            local_args_info.a2_given = 1;
            args_info->a2_given = 1;
            if (args_info->a2_arg)
              free (args_info->a2_arg); /* free previous string */
            args_info->a2_arg = gengetopt_strdup (optarg);
            if (args_info->a2_orig)
              free (args_info->a2_orig); /* free previous string */
            args_info->a2_orig = gengetopt_strdup (optarg);
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a3") == 0)
          {
            if (local_args_info.a3_given)
              {
                fprintf (stderr, "%s: `--a3' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->a3_given && ! override)
              continue;
            local_args_info.a3_given = 1;
            args_info->a3_given = 1;
            if (args_info->a3_arg)
              free (args_info->a3_arg); /* free previous string */
            args_info->a3_arg = gengetopt_strdup (optarg);
            if (args_info->a3_orig)
              free (args_info->a3_orig); /* free previous string */
            args_info->a3_orig = gengetopt_strdup (optarg);
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a4") == 0)
          {
            if (local_args_info.a4_given)
              {
                fprintf (stderr, "%s: `--a4' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->a4_given && ! override)
              continue;
            local_args_info.a4_given = 1;
            args_info->a4_given = 1;
            if (args_info->a4_arg)
              free (args_info->a4_arg); /* free previous string */
            args_info->a4_arg = gengetopt_strdup (optarg);
            if (args_info->a4_orig)
              free (args_info->a4_orig); /* free previous string */
            args_info->a4_orig = gengetopt_strdup (optarg);
          }
          /* Used with the elliptic-curve option.  */
          else if (strcmp (long_options[option_index].name, "a6") == 0)
          {
            if (local_args_info.a6_given)
              {
                fprintf (stderr, "%s: `--a6' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->a6_given && ! override)
              continue;
            local_args_info.a6_given = 1;
            args_info->a6_given = 1;
            if (args_info->a6_arg)
              free (args_info->a6_arg); /* free previous string */
            args_info->a6_arg = gengetopt_strdup (optarg);
            if (args_info->a6_orig)
              free (args_info->a6_orig); /* free previous string */
            args_info->a6_orig = gengetopt_strdup (optarg);
          }
          /* verbosity > 0 outputs extra info.  */
          else if (strcmp (long_options[option_index].name, "verbose") == 0)
          {
            if (local_args_info.verbose_given)
              {
                fprintf (stderr, "%s: `--verbose' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->verbose_given && ! override)
              continue;
            local_args_info.verbose_given = 1;
            args_info->verbose_given = 1;
            args_info->verbose_arg = strtol (optarg,&stop_char,0);
            if (args_info->verbose_orig)
              free (args_info->verbose_orig); /* free previous string */
            args_info->verbose_orig = gengetopt_strdup (optarg);
          }
          /* verify if specified rank is correct.  */
          else if (strcmp (long_options[option_index].name, "rank-verify") == 0)
          {
            if (local_args_info.rank_verify_given)
              {
                fprintf (stderr, "%s: `--rank-verify' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->rank_verify_given && ! override)
              continue;
            local_args_info.rank_verify_given = 1;
            args_info->rank_verify_given = 1;
            args_info->rank_verify_arg = strtol (optarg,&stop_char,0);
            if (args_info->rank_verify_orig)
              free (args_info->rank_verify_orig); /* free previous string */
            args_info->rank_verify_orig = gengetopt_strdup (optarg);
          }
          /* twist by fundamental quadratic characters, even functional eqn, start <= discriminant <= finish.  */
          else if (strcmp (long_options[option_index].name, "twist-quadratic-even") == 0)
          {
            if (local_args_info.twist_quadratic_even_given)
              {
                fprintf (stderr, "%s: `--twist-quadratic-even' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->twist_quadratic_even_given && ! override)
              continue;
            local_args_info.twist_quadratic_even_given = 1;
            args_info->twist_quadratic_even_given = 1;
            args_info->twist_quadratic_even_flag = !(args_info->twist_quadratic_even_flag);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
