/***************************************************************************
                          extras.c  -  description
                             -------------------
    begin                : Sun Sep 9 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "list.h"
#include "config.h"
#include "event.h"
#include "shrapnells.h"
#include "difficulty.h"
#include "levels.h"
#include "player.h"
#include "bricks.h"
#include "shots.h"
#include "paddle.h"
#include "balls.h"
#include "extras.h"
#include "frame.h"
#ifdef SOUND
#include "audio.h"
#endif

extern Diff *diff;
extern Player *player;
extern Config config;
extern Sdl sdl;
extern SDL_Surface *offscreen;
extern SDL_Surface *bkgnd; /* background + frame */
extern SDL_Surface *offscreen_backup;
extern Paddle paddle;
extern int ball_w, ball_dia;
extern float ball_v, ball_vm, ball_old_v;
extern List *balls;
extern SDL_Surface *brick_pic;
extern Brick bricks[MAP_WIDTH][MAP_HEIGHT];
extern SDL_Surface *extra_pic; /* graphics */
extern SDL_Surface *extra_shadow;
List *extras = 0; /* extras */
int active[EX_NUMBER]; /* true if extra activated */
int extra_time[EX_NUMBER]; /* time in milliseconds when extra expires: 0 unlimited */
/* wall */
extern SDL_Surface *wall_pic;
float wall_alpha = 0;
extern int shadow_size;
#ifdef SOUND
extern Sound_Chunk *wav_score, *wav_metal, *wav_std, *wav_wall, *wav_joker;
extern Sound_Chunk *wav_goldshower;
extern Sound_Chunk *wav_speedup, *wav_speeddown;
extern Sound_Chunk *wav_chaos, *wav_darkness, *wav_ghost;
extern Sound_Chunk *wav_timeadd, *wav_expl_ball, *wav_weak_ball;
extern Sound_Chunk *wav_bonus_magnet, *wav_malus_magnet, *wav_disable;
extern Sound_Chunk *wav_attach; /* handled by balls.c */
#endif

/*
====================================================================
Extra times
====================================================================
*/
enum {
    TIME_WALL   = 20000,
    TIME_METAL  = 10000,
    TIME_WEAPON = 10000,
    TIME_FROZEN =  1000,
    TIME_SLIME  = 20000,
    TIME_FAST   = 20000,
    TIME_SLOW   = 20000,
    TIME_GOLDSHOWER   = 20000,
	TIME_DARKNESS     = 20000,
	TIME_CHAOS        = 20000,
	TIME_GHOST_PADDLE = 20000,
    TIME_SPIN_RIGHT   = 20000,
    TIME_SPIN_LEFT    = 20000, 
    TIME_EXPL_BALL    = 10000,
    TIME_BONUS_MAGNET = 20000,
    TIME_MALUS_MAGNET = 20000,
    TIME_WEAK_BALL    = 20000
};

/*
====================================================================
Locals
====================================================================
*/

/*
====================================================================
Test if the paddle currently attracts extras of this type.
====================================================================
*/
int extra_attracted_by_paddle( int type ) 
{
    switch ( type ) {
        /* bonus */
        case EX_SCORE200:
        case EX_SCORE500:
        case EX_SCORE1000:
        case EX_SCORE2000:
        case EX_SCORE5000:
        case EX_SCORE10000:
        case EX_GOLDSHOWER:
        case EX_LENGTHEN:
        case EX_LIFE:
        case EX_SLIME:
        case EX_METAL:
        case EX_BALL:
        case EX_WALL:
        case EX_WEAPON:
        case EX_SLOW:
        case EX_JOKER:
        case EX_EXPL_BALL:
        case EX_BONUS_MAGNET:
            if ( paddle_attract_bonus() )
                return 1;
            return 0;
        /* malus */
        case EX_SHORTEN:
        case EX_FAST:
        /*
        case EX_SPIN_RIGHT:
        case EX_SPIN_LEFT:
        */
        case EX_MALUS_MAGNET:
        case EX_WEAK_BALL:
	    case EX_DARKNESS:
	    case EX_GHOST_PADDLE:
        case EX_FROZEN:
            if ( paddle_attract_malus() )
                return 1;
            return 0;
        /* neutral */
        case EX_DISABLE:
	    case EX_CHAOS:
        case EX_TIME_ADD:
        case EX_RANDOM:
            return 0;
    }
    return 0;
}

/*
====================================================================
Public
====================================================================
*/

/*
====================================================================
Load and delete extra graphics
====================================================================
*/
void extras_load()
{
    extras = list_create( LIST_AUTO_DELETE, NO_CALLBACK );
}
void extras_delete()
{
    if ( extras ) list_delete( extras ); extras = 0;
}
/*
====================================================================
Reset extras
====================================================================
*/
void extras_reset()
{
    list_clear( extras );
    memset( active, 0, sizeof( int ) * EX_NUMBER );
    memset( extra_time, 0, sizeof( int ) * EX_NUMBER );
}
/*
====================================================================
Create new extra at position
====================================================================
*/
void extra_create( int type, int x, int y )
{
    Extra *e = calloc( 1, sizeof( Extra ) );
    e->type = type;
    e->x = x; e->y = y;
    if (!config.trp)
        e->alpha = 0;
    else
        e->alpha = 255;
    list_add( extras, e );
}
/*
====================================================================
Use extra when paddle collected it
====================================================================
*/
void extra_use( int extra_type )
{
    Ball    *b;
    int i;

    while( extra_type == EX_RANDOM ) extra_type = rand() % (EX_NUMBER);

    switch (extra_type) {
        case EX_SCORE200:
            player->score += 200;
            if ( active[EX_JOKER] ) player->score += 200;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_SCORE500:
            player->score += 500;
            if ( active[EX_JOKER] ) player->score += 500;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_SCORE1000:
            player->score += 1000;
            if ( active[EX_JOKER] ) player->score += 1000;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_SCORE2000:
            player->score += 2000;
            if ( active[EX_JOKER] ) player->score += 2000;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_SCORE5000:
            player->score += 5000;
            if ( active[EX_JOKER] ) player->score += 5000;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_SCORE10000:
            player->score += 10000;
            if ( active[EX_JOKER] ) player->score += 10000;
#ifdef SOUND
            sound_play( wav_score );
#endif
            break;
        case EX_GOLDSHOWER:
            extra_time[EX_GOLDSHOWER] += TIME_GOLDSHOWER;
            if ( active[EX_JOKER] ) extra_time[EX_GOLDSHOWER] += TIME_GOLDSHOWER;
#ifdef SOUND
            sound_play( wav_goldshower );
#endif
            break;
        case EX_LIFE:
            if (player->lives < diff->max_lives) {
                player->lives++;
                /* update lives */
                frame_add_life();
            }
            else {
                player->score += 10000;
#ifdef SOUND
            sound_play( wav_score );
#endif
            }
            break;
        case EX_SHORTEN:
            paddle_init_resize(-1);
            break;
        case EX_LENGTHEN:
            paddle_init_resize(1);
            break;
        case EX_BALL:
            b = ball_create(paddle.x + (paddle.w - ball_w) / 2, paddle.y - ball_dia, (rand() % 90) - 45, 0.15);
            ball_mask_vel(b, b->vel.x);
            ball_get_target(b);
            list_add( balls, b );
#ifdef SOUND
            sound_play( wav_std );
#endif
            break;
        case EX_WALL:
            extra_time[EX_WALL] += TIME_WALL;
            if ( active[EX_JOKER] ) extra_time[EX_WALL] += TIME_WALL;
            if (active[EX_WALL]) {
#ifdef SOUND
                sound_play( wav_std );
#endif
                break;
            }
            for (i = 1; i < MAP_WIDTH - 1; i++) {
                bricks[i][MAP_HEIGHT - 1].type = MAP_WALL;
                bricks[i][MAP_HEIGHT - 1].id = 0;
            }
            wall_alpha = 255;
            balls_get_new_targets( -1, 0 );
#ifdef SOUND
            sound_play( wav_wall );
#endif
            break;
        case EX_METAL:
            extra_time[EX_METAL] += TIME_METAL;
            if ( active[EX_JOKER] ) extra_time[EX_METAL] += TIME_METAL;
            balls_set_type( BALL_METAL );
#ifdef SOUND
            sound_play( wav_metal );
#endif
            /* other ball extras are disabled */
            if ( active[EX_EXPL_BALL] ) {
                active[EX_EXPL_BALL] = 0;
                extra_time[EX_EXPL_BALL] = 0;
            }
            if ( active[EX_WEAK_BALL] ) {
                active[EX_WEAK_BALL] = 0;
                extra_time[EX_WEAK_BALL] = 0;
            }
            break;
        case EX_FROZEN:
            extra_time[EX_FROZEN] = TIME_FROZEN;
            paddle_freeze( 1 );
#ifdef SOUND
#endif
            break;
        case EX_WEAPON:
            extra_time[EX_WEAPON] += TIME_WEAPON;
            if ( active[EX_JOKER] ) extra_time[EX_WEAPON] += TIME_WEAPON;
            weapon_install( 1 );
#ifdef SOUND
            sound_play( wav_std );
#endif
            break;
        case EX_SLIME:
            extra_time[EX_SLIME] += TIME_SLIME;
            if ( active[EX_JOKER] ) extra_time[EX_SLIME] += TIME_SLIME;
            paddle_set_slime( 1 );
#ifdef SOUND
            sound_play( wav_attach );
#endif
            break;
        case EX_FAST:
#ifdef SOUND
            sound_play( wav_speedup );
#endif
            if ( active[EX_SLOW] || active[EX_FAST] )
                ball_v = ball_old_v;
            if ( active[EX_SLOW] ) {
                extra_time[EX_SLOW] = 0;
                active[EX_SLOW] = 0;
            }
            extra_time[EX_FAST] += TIME_FAST;
            if ( active[EX_JOKER] ) extra_time[EX_FAST] += TIME_FAST;
            ball_old_v = ball_v;
            ball_v = ball_vm;
            list_reset( balls );
            while ( ( b = list_next( balls ) ) ) {
                ball_adjust_vel(b, ball_v);
                ball_get_target(b);
            }
            break;
        case EX_SLOW:
#ifdef SOUND
            sound_play( wav_speeddown );
#endif
            if ( active[EX_SLOW] || active[EX_FAST] )
                ball_v = ball_old_v;
            if ( active[EX_FAST] ) {
                extra_time[EX_FAST] = 0;
                active[EX_FAST] = 0;
            }
            extra_time[EX_SLOW] += TIME_SLOW;
            if ( active[EX_JOKER] ) extra_time[EX_SLOW] += TIME_SLOW;
            ball_old_v = ball_v;
            ball_v = diff->v_start;
            list_reset( balls );
            while ( ( b = list_next( balls ) ) ) {
                ball_adjust_vel(b, ball_v);
                ball_get_target(b);
            }
            break;
        case EX_CHAOS:
#ifdef SOUND
            sound_play( wav_chaos );
#endif
            extra_time[EX_CHAOS] += TIME_CHAOS;
			balls_set_chaos( 1 );
			break;
        case EX_DARKNESS:
#ifdef SOUND
            sound_play( wav_darkness );
#endif
            extra_time[EX_DARKNESS] += TIME_DARKNESS;
			if ( active[EX_DARKNESS] ) break;
			/* backup offscreen and turn it black */
			FULL_DEST( offscreen ); fill_surf( 0x0 );
			FULL_DEST( sdl.screen ); fill_surf( 0x0 );
			add_refresh_rect( 0, 0, offscreen->w, offscreen->h );
            /* use dark explosions */
            exps_set_dark( 1 );
			break;
        case EX_GHOST_PADDLE:
#ifdef SOUND
            sound_play( wav_ghost );
#endif
            extra_time[EX_GHOST_PADDLE] += TIME_GHOST_PADDLE;
			paddle_set_invis( 1 );
			break;
        case EX_TIME_ADD:
#ifdef SOUND
            sound_play( wav_timeadd );
#endif
            for ( i = 0; i < EX_NUMBER; i++ )
                if ( extra_time[i] )
                    extra_time[i] += 7000;
            break;
        case EX_EXPL_BALL:
#ifdef SOUND
            sound_play( wav_expl_ball );
#endif
            balls_set_type( BALL_EXPL );
            extra_time[EX_EXPL_BALL] += TIME_EXPL_BALL;
            if ( active[EX_JOKER] ) extra_time[EX_EXPL_BALL] += TIME_EXPL_BALL;
            /* other ball extras are disabled */
            if ( active[EX_METAL] ) {
                active[EX_METAL] = 0;
                extra_time[EX_METAL] = 0;
            }
            if ( active[EX_WEAK_BALL] ) {
                active[EX_WEAK_BALL] = 0;
                extra_time[EX_WEAK_BALL] = 0;
            }
            break;
        case EX_WEAK_BALL:
#ifdef SOUND
            sound_play( wav_weak_ball );
#endif
            balls_set_type( BALL_WEAK );
            extra_time[EX_WEAK_BALL] += TIME_WEAK_BALL;
            /* other ball extras are disabled */
            if ( active[EX_METAL] ) {
                active[EX_METAL] = 0;
                extra_time[EX_METAL] = 0;
            }
            if ( active[EX_EXPL_BALL] ) {
                active[EX_EXPL_BALL] = 0;
                extra_time[EX_EXPL_BALL] = 0;
            }
            break;
        case EX_BONUS_MAGNET:
#ifdef SOUND
            sound_play( wav_bonus_magnet );
#endif
            paddle_set_attract( ATTRACT_BONUS );
            extra_time[EX_BONUS_MAGNET] += TIME_BONUS_MAGNET;
            if ( active[EX_JOKER] ) extra_time[EX_BONUS_MAGNET] += TIME_BONUS_MAGNET;
            if ( active[EX_MALUS_MAGNET] ) {
                active[EX_MALUS_MAGNET] = 0;
                extra_time[EX_MALUS_MAGNET] = 0;
            }
            break;
        case EX_MALUS_MAGNET:
#ifdef SOUND
            sound_play( wav_malus_magnet );
#endif
            paddle_set_attract( ATTRACT_MALUS );
            extra_time[EX_MALUS_MAGNET] += TIME_MALUS_MAGNET;
            if ( active[EX_BONUS_MAGNET] ) {
                active[EX_BONUS_MAGNET] = 0;
                extra_time[EX_BONUS_MAGNET] = 0;
            }
            break;
        case EX_DISABLE:
#ifdef SOUND
            sound_play( wav_disable );
#endif
            /* set all active extra times to 1 so they will expire next
               prog cycle */ 
            for ( i = 0; i < EX_NUMBER; i++ )
                if ( extra_time[i] )
                    extra_time[i] = 1;
            break;
    }
    active[extra_type] = 1;
}
/*
====================================================================
Show, hide extras
====================================================================
*/
void extras_hide()
{
    List_Entry  *entry = extras->head.next;
    Extra       *ex;
    int         x, y;
    while ( entry != &extras->tail ) {
        ex = entry->item;
        x = (int)ex->x;
        y = (int)ex->y;
        if ( config.shadow )
            DEST(sdl.screen, x, y, BRICK_WIDTH + shadow_size, BRICK_HEIGHT + shadow_size )
        else
            DEST(sdl.screen, x, y, BRICK_WIDTH, BRICK_HEIGHT )
        SOURCE(offscreen, x, y);
        blit_surf();
        if ( config.shadow )
            add_refresh_rect( x, y, BRICK_WIDTH + shadow_size, BRICK_HEIGHT + shadow_size );
        else
            add_refresh_rect( x, y, BRICK_WIDTH, BRICK_HEIGHT );
        entry = entry->next;
    }
}
void extra_show_shadow( Extra *extra )
{
	DEST( sdl.screen, (int)extra->x + shadow_size, (int)extra->y + shadow_size, BRICK_WIDTH, BRICK_HEIGHT );
    SOURCE( extra_shadow, 0, 0 );
    alpha_blit_surf( ( extra->alpha / 255 ) * ( 255 - SHADOW_ALPHA ) + SHADOW_ALPHA );
}
void extras_show()
{
    List_Entry  *entry = extras->head.next;
    Extra       *ex;
    int         x, y;
    while ( entry != &extras->tail ) {
        ex = entry->item;
        x = (int)ex->x;
        y = (int)ex->y;
        if ( config.shadow ) extra_show_shadow( ex );
        DEST(sdl.screen, x, y, BRICK_WIDTH, BRICK_HEIGHT);
        SOURCE(extra_pic, ex->type * BRICK_WIDTH, 0);
        if ( ex->alpha == 0 )
            blit_surf();
       else
            alpha_blit_surf((int)ex->alpha);
        if ( config.shadow )
            add_refresh_rect( x, y, BRICK_WIDTH + shadow_size, BRICK_HEIGHT + shadow_size );
        else
            add_refresh_rect( x, y, BRICK_WIDTH, BRICK_HEIGHT );
        entry = entry->next;
    }
}
void extras_alphashow( int alpha )
{
    List_Entry  *entry = extras->head.next;
    Extra       *ex;
    int         x, y;
    while ( entry != &extras->tail ) {
        ex = entry->item;
        x = (int)ex->x;
        y = (int)ex->y;
        DEST(sdl.screen, x, y, BRICK_WIDTH, BRICK_HEIGHT);
        SOURCE(extra_pic, ex->type * BRICK_WIDTH, 0);
        alpha_blit_surf( alpha );
        add_refresh_rect(x, y, BRICK_WIDTH, BRICK_HEIGHT);
        entry = entry->next;
    }
}
/*
====================================================================
Update extras
====================================================================
*/
void extras_update( int ms )
{
    List_Entry  *entry;
    Extra       *ex;
    Ball *ball;
    int i;
    int type, px, py;

    /* release new extras */
    while ( bricks_pop_extra( &type, &px, &py ) ) extra_create( type, px, py );
    /* check extra_time of limited extras */
    for ( i = 0; i < EX_NUMBER; i++ )
        /* extra_time of wall is updated in wall_update() */
        if ( extra_time[i] && i != EX_WALL ) {
            extra_time[i] -= ms;
            if ( extra_time[i] <= 0 ) {
                extra_time[i] = 0;
                /* expired */
                switch ( i ) {
                    case EX_SLIME: paddle_set_slime( 0 ); break;
                    case EX_WEAPON: weapon_install( 0 ); break;
                    case EX_FROZEN:
                        paddle_freeze( 0 );
                        break;
                    case EX_EXPL_BALL:
                    case EX_WEAK_BALL:
                    case EX_METAL: 
                        balls_set_type( BALL_NORMAL ); 
                        break;
                    case EX_SLOW:
                    case EX_FAST:
                        ball_v = ball_old_v;
                        list_reset( balls );
                        while ( ( ball = list_next( balls ) ) ) {
                            ball_adjust_vel(ball, ball_v);
                            ball_get_target(ball);
                        }
                        break;
					case EX_GHOST_PADDLE:
						paddle_set_invis( 0 );
						break;
					case EX_DARKNESS:
						/* restore offscreen */
                        FULL_DEST( offscreen ); FULL_SOURCE( bkgnd ); blit_surf();
						bricks_draw();
                        frame_draw_lives( player->lives, diff->max_lives );
						/* back to screen */
						FULL_DEST( sdl.screen ); FULL_SOURCE( offscreen ); blit_surf();
						add_refresh_rect( 0, 0, offscreen->w, offscreen->h );
                        /* use bright explosions */
                        exps_set_dark( 0 );
						break;
					case EX_CHAOS:
						balls_set_chaos( 0 );
						break;
                    case EX_BONUS_MAGNET:
                    case EX_MALUS_MAGNET:
                        paddle_set_attract( ATTRACT_NONE );
                        break;
                }
                /* set deactivated */
                active[i] = 0; /* wall is handled in wall_...() */
            }
        }
    /* move extras and check if paddle was hit */
    entry = extras->head.next;
    while ( entry != &extras->tail ) {
        ex =entry->item;
        ex->y += 0.05 * ms;
        /* if this extra type is attracted by paddle also change the x position */
        if ( extra_attracted_by_paddle( ex->type ) ) {
            if ( ex->x + ( BRICK_WIDTH >> 1 ) < paddle.x + ( paddle.w >> 1 ) ) {
                ex->x += 0.05 * ms;
                if ( ex->x + ( BRICK_WIDTH >> 1 ) > paddle.x + ( paddle.w >> 1 ) )
                    ex->x = paddle.x + ( paddle.w >> 1 ) - ( BRICK_WIDTH >> 1 );
            }
            else {
                ex->x -= 0.05 * ms;
                if ( ex->x + ( BRICK_WIDTH >> 1 ) < paddle.x + ( paddle.w >> 1 ) )
                    ex->x = paddle.x + ( paddle.w >> 1 ) - ( BRICK_WIDTH >> 1 );
            }
        }
		if ( !active[EX_DARKNESS] ) {
        	if ( ex->alpha > 0 )
            	ex->alpha -= 0.25 * ms;
		}
		else {
			if ( ex->alpha < 128 ) 
				ex->alpha = 128;
        	if (ex->alpha > 128)
            	ex->alpha -= 0.25 * ms;
		}
        if (ex->alpha < 0)
            ex->alpha = 0;
        entry = entry->next;
        if (ex->y >= sdl.screen->h)
            list_delete_entry( extras, entry->prev );
        else {
            // contact with paddle core ? //
			if ( paddle_solid() )
            if (ex->x + BRICK_WIDTH > paddle.x && ex->x < paddle.x + paddle.w - 1 && ex->y + BRICK_HEIGHT > paddle.y && ex->y < paddle.y + paddle.h) {
                /* some types may not be simply used by extra_use() */
                switch ( ex->type ) {
                    /* if ex->type is EX_JOKER check all extras and use all bonus and quit */
                     case EX_JOKER:
#ifdef SOUND
                        sound_play( wav_joker );
#endif
                        /* set EX_JOKER as active so times may be doubled in extra_use */
                        active[EX_JOKER] = 1;
                        list_reset( extras );
                        while ( ( ex = list_next( extras ) ) ) {
                            if ( ex->type != EX_JOKER )
                            if ( ex->type != EX_SHORTEN )
                            if ( ex->type != EX_FROZEN )
                            if ( ex->type != EX_FAST )
                            if ( ex->type != EX_RANDOM )
                            if ( ex->type != EX_DARKNESS )
                            if ( ex->type != EX_GHOST_PADDLE )
                            if ( ex->type != EX_CHAOS )
                            if ( ex->type != EX_DISABLE )
/*                                
                            if ( ex->type != EX_SPIN_RIGHT )
                            if ( ex->type != EX_SPIN_LEFT )
*/
                            if ( ex->type != EX_MALUS_MAGNET )
                            if ( ex->type != EX_WEAK_BALL )
                                extra_use( ex->type );
                            list_delete_item( extras, ex );
                        }
                        active[EX_JOKER] = 0;
                        entry = &extras->tail;
                        break;
                    default:
                        extra_use(ex->type);
                        list_delete_entry( extras, entry->prev );
                        break;
                }
            }
        }
    }
}
/* wall */
void wall_hide()
{
    if ( !active[EX_WALL] ) return;
    DEST( sdl.screen, BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
    SOURCE( offscreen, BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT );
    blit_surf();
    add_refresh_rect( BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
}
void wall_show()
{
    if ( !active[EX_WALL] ) return;
    DEST( sdl.screen, BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
    SOURCE( wall_pic, 0, 0 );
    if ( config.trp && wall_alpha )
        alpha_blit_surf( wall_alpha );
    else
        blit_surf();
}
void wall_alphashow( int alpha )
{
    if ( !active[EX_WALL] ) return;
    DEST( sdl.screen, BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
    SOURCE( wall_pic, 0, 0 );
    alpha_blit_surf( alpha );
    add_refresh_rect( BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
}
void wall_update( int ms )
{
    int i;

    if ( !active[EX_WALL] ) return;
    if ( extra_time[EX_WALL] > 0 ) {
	    extra_time[EX_WALL] -= ms;
		if ( extra_time[EX_WALL] < 0 ) extra_time[EX_WALL] = 0;
        /* still appearing? */
        if (wall_alpha > 0) {
			wall_alpha -= 0.25 * ms;
        	if (wall_alpha < 0) wall_alpha = 0;
		}				
    }
    else {
        wall_alpha += 0.25 * ms;
        if ( wall_alpha >= 255 ) {
            wall_alpha = 255;
            /* disappear */
            wall_hide();
            add_refresh_rect( BRICK_WIDTH, sdl.screen->h - BRICK_HEIGHT, wall_pic->w, wall_pic->h );
            active[EX_WALL] = 0;
            for (i = 1; i < MAP_WIDTH - 1; i++) bricks[i][MAP_HEIGHT - 1].type = MAP_EMPTY;
            balls_get_new_targets( -1, 0 );
        }
    }
}
