/*
    This file is part of the LaTeX service for GNUstep 
    (http://www.roard.com/latexservice)
    Copyright (C) 2003 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

@interface LaTeXService : NSObject
- (void) textToRender: (NSPasteboard*)bp
	userData: (NSString*)ud
	   error: (NSString**)err;
@end

@implementation LaTeXService

- (void) textToRender: (NSPasteboard*)pb
	userData: (NSString*)ud
	   error: (NSString**)err
{
  NSString	*equation;
  NSArray	*types;
  NSUserDefaults *defs = [NSUserDefaults standardUserDefaults];

  *err = nil;
  types = [pb types];
  if (![types containsObject: NSStringPboardType])
    {
      *err = @"No string type supplied on pasteboard";
      return;
    }

  equation = [pb stringForType: NSStringPboardType];
  if (equation == nil)
    {
      *err = @"No string value supplied on pasteboard";
      return;
    }
  NSString* out = [equation uppercaseString];
  types = [NSArray arrayWithObjects: NSStringPboardType, NSTIFFPboardType,nil];
  [pb declareTypes: types owner: nil];
  [pb setString: equation forType: NSStringPboardType];
  NSMutableString* content = [NSMutableString stringWithString: @"\\documentclass{article}\n"];
  [content appendString: @"\\usepackage[latin1]{inputenc}\n"];
  [content appendString: @"\\batchmode\n"];
  [content appendString: @"\\begin{document}\n"];
  [content appendString: @"\\pagestyle{empty}\n"];
  [content appendString: equation];
  [content appendString: @"\n\\end{document}"];
  BOOL ret = [content writeToFile: @"temp.tex" atomically: YES];

  if (ret)
  {
  	NSTask* taskLaTeX = [NSTask launchedTaskWithLaunchPath: @"/usr/bin/tex"
			arguments: [NSArray arrayWithObjects: @"-progname=latex",@"temp.tex",nil]];
	[taskLaTeX waitUntilExit];
  	NSTask* taskDVI2PNG = [NSTask launchedTaskWithLaunchPath: @"/usr/local/bin/dvipng" 
			arguments: [NSArray arrayWithObjects: @"-otemp.png",@"-Ttight",@"temp.dvi",nil]];
	[taskDVI2PNG waitUntilExit];
	NSTask* taskPNG2TIFF = [NSTask launchedTaskWithLaunchPath: @"/usr/bin/convert"
			arguments: [NSArray arrayWithObjects: @"temp.png",@"temp.tiff",nil]];
	[taskPNG2TIFF waitUntilExit];
        NSImage* equationImage = [[NSImage alloc] initWithContentsOfFile: @"temp.tiff"];
	[pb setData: [equationImage TIFFRepresentation] forType: NSTIFFPboardType];
	[equationImage release];
  }
}
@end

int main (int argc, char** argv, char **env)
{
  NSAutoreleasePool *pool;
  LaTeXService *server;

#ifdef GS_PASS_ARGUMENTS
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif
  pool = [NSAutoreleasePool new];
  server = [LaTeXService new];

  if (server == nil)
    {
      NSLog(@"Unable to create server object.\n");
      exit(EXIT_FAILURE);
    }

  NSRegisterServicesProvider(server, @"LaTeXService");

  [[NSRunLoop currentRunLoop] run];

  exit(EXIT_SUCCESS);
}


