#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
ORIGDIR=lapack-$2
DIR=lapack-$2+dfsg
TAR=../lapack_$2+dfsg.orig.tar.bz2

# clean up the upstream tarball
tar -z -x -f $3
rm $3
mv $ORIGDIR $DIR
(cd $DIR
mv TESTING testing; ln -s testing TESTING
mv SRC src; ln -s src SRC
mv INSTALL install; ln -s install INSTALL
mv BLAS blas; ln -s blas BLAS
rm lapacke/example/example_DGESV_rowmajor.c lapacke/example/example_ZGESV_rowmajor.c
)
echo tar -j -c -f $TAR $DIR
tar -j -c -f $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
    . .svn/deb-layout
    mv $TAR $origDir
    echo "moved $TAR to $origDir"
fi

exit 0
