/* ex: set tabstop=4: */

#ifndef TYPES_H
#define TYPES_H

#include <sys/types.h> /* u_char and friends */
#ifndef WIN32
	#include <stdint.h>
#endif

#ifndef __cplusplus
	typedef int bool;
#endif

#ifdef WIN32
	typedef unsigned int uint32_t;
	typedef unsigned short uint16_t;
	typedef unsigned char uint8_t;
	typedef unsigned long u_long;
	typedef unsigned int u_int;
	typedef unsigned short u_short;
	typedef unsigned char u_char;
#endif

/* * * * our basic types * * * * */

/**
 * description of supported protocols
 */
struct prot_descr {
	const char *tla; /* short descr */
	const char *full; /* full descr */
};


/**
 * an ethernet address
 */
struct mac {
	u_char addr[6];
	struct mac_prot *prot;
	struct mac_vend *vend;
};

/**
 * a reserved protocol MAC address
 */
struct mac_prot {
	u_char addr[6];
	u_char len;
	int prot_id;
	const char *descr;
};


/**
 * an IP address
 */
struct ip {
	int version;
	u_char mask[16]; /* mask */
	union {
		u_char v6[16];
		u_char v4[4];
	} addr;
};
#define IP_MASK_EMPTY	"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"

/**
 *
 */
struct mac_ip {
	struct mac mac;
	struct ip ip;
};

/**
 * used just as a wrapper to assoicate 2 pointers
 */
struct mac_ip_ptr {
	struct mac *mac;
	struct ip *ip;
};

/**
 * a special IP address
 */
struct ip_prot {
	struct ip ip;
	u_char offset;
	u_char len;
	int prot_id;
	const char *descr;
};

#if 0
/**
 * a reserved vendor MAC address
 */
struct mac_vend {
	u_char addr[3];
	u_char len;
	int vend_id;
};
#endif



/**
 *
 */
struct mac_vend {
	char unsigned prefix[3];
	char vendor[63+1];
};


/**
 *
 */
struct port {
	uint16_t num;
	uint16_t prot_id;
};


#endif

