/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *      Copyright 1996 The Ohio State University
 *      GDB/RBD
 *
 *	$Id: TRIL.c,v 6.3 1999/07/28 00:32:07 jsquyres Exp $
 *
 *	Function:	- f2c F77 interface for libtrillium functions
 */

#include <stdlib.h>

#include <lam_config.h>

#include <portable.h>
#include <preq.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*f2cstring();

/*
 * F77/C interface
 */
#if LAM_FORTRANNOUNDERSCORE
#define rpwt_		rpwt
#define rpldgo_		rpldgo
#endif

/*
 * simple wrappers
 */
void rpwt_(n, p, s, ie) int4 *n, *p, *s, *ie;
		{ *ie = rpwait(n, p, s) ? errno : 0; }

/*
 * thicker wrappers
 */
void
rpldgo_(srcnode, destnode, filename, flags, pid, idx, ierror, lstr)

int4			*srcnode;
int4			*destnode;
char			*filename;
int4			*flags;
int4			*pid;
int4			*idx;
int4			*ierror;
unsigned int		lstr;

{
	char		*cstr;
	int		r;

	if ((cstr = f2cstring(filename, lstr)) == 0) {
		*ierror = errno;
		return;
	}

	r = rploadgo(*srcnode, *destnode, cstr, *flags, (char **) 0, pid, idx);
	*ierror = r ? errno : 0;

	free(cstr);
}
