/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm_usysv.c,v 1.2 2001/01/10 20:20:54 jsquyres Exp $
 *
 *	Function:	- usysv transport low-level routines
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>
#include <typical.h>
#include <t_types.h>

#include <rpi_shm.h>

/*
 * external functions
 */
extern void		lam_deregister_object();

/*
 * # loops before usleep()
 */
int			_lock_poll_read = READPOLLCOUNT;	
int			_lock_poll_write = WRITEPOLLCOUNT;	

/*
 * private variables
 */
static struct sembuf	exit_lock = { 0, -1, 0 };
static struct sembuf	exit_unlock = { 0, 1, 0 };
static struct sembuf	exit_op = { 1, -1, IPC_NOWAIT };

#if LAM_HAVE_UNION_SEMUN
static union semun	semctl_arg;
#else
static union {
	int		val;
	struct semid_ds	*buf;
	unsigned short	*array;
} semctl_arg;
#endif


/*
 *	_shm_cleanup
 *
 *	Function:	- clean up a process's shared memory structures
 *	Accepts:	- process
 *	Returns:	- 0 or LAMERROR
 */
int
_shm_cleanup(ps)

struct c2c_proc		*ps;

{
	char		obj[32];
	int		val;			/* cleanup counter */

	if (semop(ps->cp_sem, &exit_lock, 1) < 0) return(LAMERROR);
	if (semop(ps->cp_sem, &exit_op, 1) < 0) return(LAMERROR);

	semctl_arg.val = 0;
	val = semctl(ps->cp_sem, 1, GETVAL, semctl_arg);
	if (val < 0) return(LAMERROR);

	shmdt(_shm_membase);

	if (semop(ps->cp_sem, &exit_unlock, 1) < 0) return(LAMERROR);

	if (val == 0) {
/*
 * The other side of the shared area has already cleaned up so
 * we can delete the semaphores and deregister the shared structures.
 */
		semctl(ps->cp_sem, 0, IPC_RMID, semctl_arg);
		shmctl(ps->cp_shm, IPC_RMID, (struct shmid_ds *) 0);

		sprintf(obj, "%d", ps->cp_sem);
		lam_deregister_object('s', obj);
		sprintf(obj, "%d", ps->cp_shm);
		lam_deregister_object('m', obj);
	}

	return(0);
}
