/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	RBD
 *
 *	Function:	- receives a message at the datalink sublayer
 *			- do not overwrite the header, only change the
 *			  nh_length and nh_type fields and the data pouch
 */

#include <string.h>

#include <net.h>
#include <typical.h>

int
drecv(nhead)

struct nmsg		*nhead;

{
	struct nmsg	incoming;	/* received network message header */
/*
 * Receive the message in a separate header.
 */
	memcpy((char *) &incoming, (char *) nhead, sizeof(struct nmsg));

	if (frecv(&incoming)) return(LAMERROR);
/*
 * Copy the received nh_type and nh_length fields and the data pouch.
 */
	nhead->nh_type = incoming.nh_type;
	nhead->nh_length = LAM_min(incoming.nh_length, nhead->nh_length);
	memcpy((char *) nhead->nh_data, (char *) incoming.nh_data,
			NHDSIZE * sizeof(int4));

	return(0);
}

/*
 *	dtry_recv
 *
 *	Function:	- non-blocking drecv()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_recv(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = drecv(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
