/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: testcancel.c,v 6.3 1999/12/31 21:27:39 jsquyres Exp $
 *
 *	Function:	- test if cancellation succeeded
 *	Accepts:	- ptr status structure
 *			- ptr flag (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
  MPI_Test_cancelled - Tests to see if a request was cancelled

Input Parameter:
. pstat - status object (Status) 

Output Parameter:
. pflag - true (1) if the request has been cancelled, false (0)
otherwise (logical)

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N ACK
@*/
int MPI_Test_cancelled(MPI_Status *pstat, int *pflag)
{
	lam_setfunc(BLKMPITESTCANCEL);

	if ((pstat == 0) || (pflag == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITESTCANCEL, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pflag = (pstat->MPI_SOURCE == MPI_CANCEL_SOURCE) ? 1 : 0;

	lam_resetfunc(BLKMPITESTCANCEL);
	return(MPI_SUCCESS);
}
