/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tcreatekey.c,v 1.1 2001/01/29 21:45:14 bbarrett Exp $
 *
 *	Function:	- create a datatype attribute key
 *	Accepts:	- copy function
 *			- delete function
 *			- key (out)
 *			- extra state info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Type_create_keyval - Create a datatype attribute key

Input Parameters:
+ copyfunc - Copy callback function for type_keyval (function) 
. delfunc - Delete callback function for type_keyval (function) 
- extra - extra state for callback functions

Output Parameter:
+ key - key value for future access (integer)

.N fortran

.N IMPI_MPI2

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_TYPE
.N MPI_ERR_KEYVAL
.N MPI_ERR_ARG

.seealso MPI_Type_free_keyval(3), MPI_Type_get_attr(3), MPI_Type_set_attr(3), MPI_Type_delete_attr(3)

.N WEB
@*/

int
MPI_Type_create_keyval(cpyfunc, delfunc, key, extra)

MPI_Type_copy_attr_function	*cpyfunc;
MPI_Type_delete_attr_function	*delfunc;
int				*key;
void				*extra;

{
        int 		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPITCREATEKEYVAL);

	err = lam_keyval_create((void_fn *) cpyfunc, (void_fn *) delfunc, 
				key, extra, LAM_AKTYPE);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCREATEKEYVAL, err));
	}

	lam_resetfunc_m(BLKMPITCREATEKEYVAL);
	return(MPI_SUCCESS);
}
