/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: errcreate.c,v 6.4 1999/12/31 21:27:22 jsquyres Exp $
 *
 *	Function:	- create error handler
 *	Accepts:	- error function
 *			- error handler (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*@
  MPI_Errhandler_create - Creates an MPI-style error handler on a communicator

Input Parameter:
. function - user defined error handling procedure 

Output Parameter:
. errhandler - MPI error handler (handle) 

.N Wrapper MPI_Comm_create_errhandler

.N ACK
@*/
int MPI_Errhandler_create(MPI_Handler_function *errfunc, 
			  MPI_Errhandler *errhdl)
{
	lam_initerr_m();
	lam_setfunc_m(BLKMPIERRCREATE);
/*
 * Check the arguments.
 */
	if ((errfunc == 0) || (errhdl == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCREATE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the handler.
 */
	*errhdl = (MPI_Errhandler) malloc((unsigned) sizeof(struct _errhdl));
	if (*errhdl == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*errhdl)->eh_func = (void (*)()) errfunc;
	(*errhdl)->eh_f77handle = -1;
	(*errhdl)->eh_refcount = 1;
	(*errhdl)->eh_flags = LAM_EHCOMM;

	lam_resetfunc_m(BLKMPIERRCREATE);
	return(MPI_SUCCESS);
}
