/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Id: ttime.c,v 1.2 2000/10/09 22:36:05 jsquyres Exp $
 *
 *	Function:	- returns the contents of a system timer
 *			  expressed in seconds.
 *			- used primarily for recording elapsed 
 *			  time in the user code, in a portable
 *			  manner
 *			- The resolution is not guaranteed, as it
 *			  depends on the underlying hardware,
 *			  but the units (seconds) are
 *			  guaranteed.
 *			- This code is for OTB and uses the 
 *			  Unix(tm) timing support.
 *			- based on Trollius 2.0, Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 */

#include <sys/time.h>

/*
 * external variables
 */
extern int errno;

/*
 * ttime() returns the contents of the system timer (a measure
 * of time since an arbitrary but fixed point in time) expressed
 * in seconds. 
 */

double
ttime()
{
  struct timeval now;
  double sec;
/*
 * Get the system time.
 */
  if (gettimeofday(&now, (struct timezone *) 0)) {
    return(0);
  }
/*
 * Return time in seconds.
 */
  sec = (double) now.tv_sec + (((double) now.tv_usec) / 1000000.0);
  return(sec);
}
