/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: filed.h,v 6.3 1999/06/12 17:11:28 kmeyer1 Exp $
 *
 *	Function:	- general templates and contants used by filed
 */

#ifndef _FILED_H
#define _FILED_H

#include <portable.h>

/*
 * Trollius file descriptor
 */
struct fdesc {
	int4		f_tfd;		/* Trollius file descriptor */
	int4		f_fd;		/* Unix file descriptor */
	int4		f_ptr;		/* current pointer within file */
	int4		f_tflags;	/* Trollius peculiar flags */
	int4		f_flags;	/* Unix flags */
	int4		f_flow;		/* total data flow */
	int4		f_count;	/* open count O_REUSE */
	int4		f_src_node;	/* last client's node */
	int4		f_src_event;	/* last client's event */
	char		*f_name;	/* file name */
	struct fdesc	*f_next;	/* next entry in file desc. list */
	struct fdesc	*f_prev;	/* previous entry in file desc. list */
};

/*
 * nulls
 */
#define FDNULL		((struct fdesc *) 0)

/*
 * limits
 */
#define ACTIVEMAX	64		/* filed's open descriptors */

/*
 * codes
 */
#define FMT		'f'		/* formatted F77 file */
#define UFMT		'u'		/* unformatted F77 file */


#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern int	fdlock __ARGS((struct fdesc *));

#ifdef __cplusplus
}
#endif

#endif	/* _FILED_H */
