// -*- c++ -*-
//
// $Id: user_bcast.cc,v 1.1.1.1.2.1 2001/10/29 04:32:52 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include <iostream.h>
#include <mpi++.h>


void user_bcast(int buffer[], int count, MPI::Intracomm comm);

int 
main(int argc, char **argv)
{
  int rank, size;
  int msg[10];

  // Start up MPI 
  MPI::Init(argc, argv);

  rank = MPI::COMM_WORLD.Get_rank();
  size = MPI::COMM_WORLD.Get_size();
 
  // Create an array to broadcast on the last process 
  if (rank == size - 1) {
    cout << "Broadcast: ";
    for (int i = 0; i < 10; i++) {
      msg[i] = i;
      cout << " " << msg[i] << " ";
    }
    cout << endl;
  }

  // Do the broadcast 
  user_bcast(msg, 10, MPI::COMM_WORLD);

  // If we are the console, print what we got 
  if (rank == 0) {
    cout << "process  " << rank << " got:";
    for (int i = 0; i < 10; i++)
      cout << " " << msg[i] << " ";
    cout << endl;
  }

  // Quit MPI 
  MPI::Finalize();

  return 0;
}


void
user_bcast(int buffer[], int count, MPI::Intracomm comm)
{
  int rank = comm.Get_rank();
  int size = comm.Get_size();

  /* The last process loops to send to everyone in the communicator. */
  /* Do a Waitall to wait for all messages to finish sending */

  if (rank == size - 1 ) {

    MPI::Request* reqarray = new MPI::Request[size-1];
    
    for (int dest = 0; dest < size - 1; dest++ )
      reqarray[dest] = comm.Isend(buffer, count, MPI::INT, dest, 4);

    MPI::Request::Waitall(size-1, reqarray);
  } 

  /* If we are not the last process process, we should go into a receive */
  /* and wait for it to complete */

  else {
    MPI::Request request;
    
    request = comm.Irecv(buffer, count, MPI::INT, size - 1, MPI::ANY_TAG);
    request.Wait();
  }
}
