dnl -*- shell-script -*-
dnl
dnl $Id: os_find_depdirs.m4,v 1.1 2000/10/17 12:05:18 jsquyres Exp $
dnl

define([LSC_OS_FIND_DEPDIRS],[
#
# Arguments: list of .h files to include
#            prefix (optional)
#
# Dependencies: None
#
# Looks for the include directories necessary for a compiler
#
# Will call AC_PROG_CPP or AC_PROG_CXXCPP if it has not been 
# called already (depending on autoconf's current language)
#
# Sets prefix_OS_DEPDIRS to "-Idir1 -Idir2..." or blank
# Need to call AC_SUBST manually
#

# Get list of #include's
lsc_includes="$1"

# Figure out what prefix to use
lsc_prefix="$2"
if test "$lsc_prefix" = ""; then
    lsc_prefix="LSC"
fi

# Get what language autoconf is currently set for; get the right
# preprocessor and flags
if test "$ac_ext" = "c"; then
    if test "$?CPP" = "0" -o "`echo $CPP`" = ""; then
	AC_PROG_CPP
    fi
    lsc_cpp="$CPP"
elif test "$ac_ext" = "C"; then
    if test "$?CXXCPP" = "0" -o "`echo $CXXCPP`" = ""; then
	AC_PROG_CXXCPP
    fi
    lsc_cpp="$CXXCPP"
else
    AC_MSG_WARN([autoconf is set for a language that OS_FIND_DEPDIRS])
    AC_MSG_WARN([does not understand.])
    AC_MSG_ERROR([cannot continue.])
fi

# Look for the include dependencies
for lsc_file in $lsc_includes ; do
    echo '#include <'$lsc_file'>' >> conftest.$ac_ext
done
cat >> conftest.$ac_ext <<EOF

int main(int argc, char* argv[]) { return 0; }
EOF

# Preprocess and parse
echo 'configure:__oline__: '$lsc_cpp conftest.$ac_ext' | lots of ugly grepping' >&5
$lsc_cpp conftest.$ac_ext | grep '^#.*\"' | grep -v '^#pragma' | \
    grep -v '^#ident' | sed -e 's/#.*\"\(.*\)\".*$/\1/' | \
    sort -u - | grep -v conftest.$ac_ext > conftest.out 2>&5
lsc_temp=
rm -f conftest2.out
touch conftest2.out

# Strip the directory names
for lsc_file in `cat conftest.out`; do
    lsc_temp2="`dirname $lsc_file`"
    if test "$lsc_temp" != "$lsc_temp2"; then
	echo "$lsc_temp2" >> conftest2.out
	lsc_temp="$lsc_temp2"
    fi
done

# Build up the -I list
lsc_depdirs=
for lsc_dir in `sort -u conftest2.out | uniq`; do
    lsc_pwd="`pwd`"
    cd "$lsc_dir"
    lsc_real_dir="`pwd`"
    cd "$lsc_pwd"

    for lsc_file in $lsc_includes; do
	if test -f $lsc_real_dir/$lsc_file -a \
	    "`echo $lsc_depdirs | grep $lsc_real_dir`" = ""; then
	    lsc_depdirs="-I$lsc_real_dir $lsc_depdirs"
	fi
    done
done
lsc_name="${lsc_prefix}_OS_DEPDIRS"
lsc_str="${lsc_name}=\"$lsc_depdirs\""
eval $lsc_str

# Clean up
rm -f conftest*
unset lsc_cpp lsc_temp lsc_temp2 lsc_prefix lsc_str lsc_dir lsc_name \
    lsc_file lsc_depdirs lsc_includes lsc_pwd lsc_real_dir])dnl
