dnl -*- shell-script -*-

#
# $Id: lam_check_typeof_getsockopt_optlen.m4,v 1.1 2000/10/17 12:05:17 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_CHECK_TYPEOF_GETSOCKOPT_OPTLEN,[
# Determine type of optlen parameter of getsockopt()
AC_MSG_CHECKING(type of getsockopt optlen parameter)

try_getsockopt_optlen() {
    cat > conftest.c <<EOF
#include <sys/types.h>  
#include <sys/socket.h> 
int foobar(void *optval)
{
    $type optlen=0;
    return getsockopt(0, SOL_SOCKET, SO_SNDBUF, optval, &optlen);
}
EOF
    cat conftest.c >&5
    $CC $CFLAGS -c conftest.c 1> conftest.out 2>&1
    cat conftest.out >&5
    foo="wc conftest.out | awk '{ print $"
    foo="${foo}1 }'"
    ret=`eval $foo`
    rm -f conftest.*
}

types="socklen_t int size_t unsigned-int long unsigned-long"
for type in $types; do
    type=`echo $type | sed 's/-/ /g'`
    try_getsockopt_optlen
    if test "$ret" = "0"; then
        break
    fi
done
AC_DEFINE_UNQUOTED(LAM_SOCK_OPTLEN_T, $type)
AC_MSG_RESULT([$type])])dnl
