dnl -*- shell-script -*-
dnl
dnl $Id: cxx_have_nothrow_new.m4,v 1.1 2000/10/17 12:05:16 jsquyres Exp $
dnl

define([LSC_CXX_HAVE_NOTHROW_NEW],[
#
# Arguments: prefix (optional)
#
# Depdendencies: None
#
# Check to see if the C++ compiler has std::nothrow support for new
# and new[]
#
# Defines prefix_CXX_NOTHROW_NEW_ARG to be either "(std::nothrow)" or ""
# Defines prefix_CXX_NOTHROW_NEW to be either 1 or 0
# Sets prefix_CXX_NOTHROW_NEW to be 1 or 0
#

# Figure out what prefix to use
lsc_prefix="$1"
if test "$lsc_prefix" = ""; then
    lsc_prefix="LSC"
fi

# Do the rest
if test "$?CXXFLAGS" = 0; then
    CXXFLAGS=""
fi
AC_MSG_CHECKING([whether $CXX has new(std::nothrow)])
rm -f conftest.cc conftest.o
cat > conftest.cc <<EOF
#include <new>

int main(int argc, char* argv[]) {
  int *baz;
  unsigned int foo = 3;
  baz = new(std::nothrow) int;
  baz = new(std::nothrow) int[[foo - 1]];
}
EOF
echo configure:__oline__: $CXX $CXXFLAGS conftest.cc -o conftest >&5 
$CXX $CXXFLAGS conftest.cc -o conftest >&5 2>&5
if test -f conftest; then
    lsc_result=1
    lsc_define="(std::nothrow)"
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.cc >&5
    lsc_result=0
    lsc_define=""
    AC_MSG_RESULT([no])
fi

# Set the result
lsc_name="${lsc_prefix}_CXX_NOTHROW_NEW"
lsc_str="${lsc_name}=$lsc_result"
eval $lsc_str
AC_DEFINE_UNQUOTED($lsc_name, $lsc_result)
lsc_name="${lsc_prefix}_CXX_NOTHROW_NEW_ARG"
AC_DEFINE_UNQUOTED($lsc_name, $lsc_define)

# Clean up
rm -f conftest*
unset lsc_prefix lsc_result lsc_define lsc_name lsc_str])dnl

