dnl -*- shell-script -*-
dnl
dnl $Id: cxx_have_exceptions.m4,v 1.1 2000/10/17 12:05:16 jsquyres Exp $
dnl

define([LSC_CXX_HAVE_EXCEPTIONS],[
#
# Arguments: prefix (optional)
#
# Depdencies: None
#
# Check to see if the C++ compiler can handle exceptions 
#
# Sets prefix_CXX_EXCEPTIONS to 1 if compiler has exceptions, 0 if not
#

# Figure out what prefix to use
lsc_prefix="$1"
if test "$lsc_prefix" = ""; then
    lsc_prefix="LSC"
fi

AC_MSG_CHECKING([for throw/catch])
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE(, int i=1; throw(i);, lsc_result=1, lsc_result=1)
if test "$lsc_result" = "1"; then
    AC_MSG_RESULT([yes])
else
    AC_MSG_RESULT([no])
fi

# Set the result
lsc_name="${lsc_prefix}_CXX_EXCEPTIONS"
lsc_str="${lsc_name}=$lsc_result"
eval $lsc_str

# Clean up
AC_LANG_RESTORE
unset lsc_prefix lsc_result lsc_name lsc_str])dnl
