/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: mpil_id.c,v 6.2 1999/05/25 22:08:08 kmeyer1 Exp $
 *
 *	Function:	- identifers for MPI opaque objects
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * backward compatibility
 */
int MPI_Comm_get_contextid(comm, cid) MPI_Comm comm; int *cid;
	{ return(MPIL_Comm_id(comm, cid)); }

/*
 *	MPIL_Comm_id
 *
 *	Function:	- returns the context ID
 *	Accepts:	- communicator
 *			- context ID (out)
 */
int
MPIL_Comm_id(comm, pcid)

MPI_Comm		comm;
int			*pcid;

{
	lam_initerr();
	lam_setfunc(BLKMPILCOMMID);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (pcid == 0) {
		return(lam_errfunc(comm,
			lam_getfunc(), lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pcid = comm->c_contextid;

	lam_resetfunc(BLKMPILCOMMID);
	return(MPI_SUCCESS);
}

/*
 *	MPIL_Comm_gps
 *
 *	Function:	- translates MPI comm/rank to LAM nid/pid
 *			- if the communicator is an intercommunicator then
 *			  rank is taken to be in the remote group
 *	Accepts:	- communicator
 *			- rank
 *			- node ID (out)
 *			- process ID (out)
 */
int
MPIL_Comm_gps(comm, rank, pnid, ppid)

MPI_Comm		comm;
int			rank;
int			*pnid;
int			*ppid;

{
	MPI_Group	grp;

	lam_initerr();
	lam_setfunc(BLKMPILCOMMGPS);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((pnid == 0) || (ppid == 0)) {
		return(lam_errfunc(comm,
			lam_getfunc(), lam_mkerr(MPI_ERR_ARG, 0)));
	}

	grp = (LAM_IS_INTER(comm)) ? comm->c_rgroup : comm->c_group;
	
	if ((rank == MPI_ANY_SOURCE) || (rank < 0) ||
			(rank >= grp->g_nprocs)) {
		return(lam_errfunc(comm,
			lam_getfunc(), lam_mkerr(MPI_ERR_RANK, 0)));
	}

	*pnid = grp->g_procs[rank]->p_gps.gps_node;
	*ppid = grp->g_procs[rank]->p_gps.gps_pid;

	lam_resetfunc(BLKMPILCOMMGPS);
	return(MPI_SUCCESS);
}

/*
 *	MPIL_Type_id
 *
 *	Function:	- returns the type ID
 *	Accepts:	- datatype
 *			- type ID (out)
 */
int
MPIL_Type_id(dtype, ptid)

MPI_Datatype		dtype;
int			*ptid;

{
	lam_initerr();
	lam_setfunc(BLKMPILTYPEID);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (ptid == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*ptid = dtype->dt_label;

	lam_resetfunc(BLKMPILTYPEID);
	return(MPI_SUCCESS);
}
