/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: lamunix.c,v 6.5 1999/07/28 00:31:53 jsquyres Exp $
 * 
 *	Function:	- We make UNIX portable in here!
 *			- #ifdef'ing the universe is cool!
 */

#include <lam_config.h>
#include <signal.h>
#include <stdlib.h>

/*
 * global functions
 */
void			(*(_lam_signal()))();
void			_lam_atexit();

/*
 *	_lam_signal
 *
 *	Function:	- signal() wrapper
 */
void (*(
_lam_signal(signum, handler)))()

int			signum;
void			(*handler)();

{
	struct sigaction
			newact, old;

	newact.sa_handler = handler;
	sigemptyset(&newact.sa_mask);
	newact.sa_flags = 0;

#if LAM_HAVE_SA_RESTART
	newact.sa_flags |= SA_RESTART;
#endif

	if (sigaction(signum, &newact, &old)) {
		return(SIG_ERR);
	}

	return(old.sa_handler);
}

/*
 *	_lam_atexit
 *
 *	Function:	- wrapper for atexit()
 */
void
_lam_atexit(func)

void			(*func)();

{
#if HAVE_ATEXIT
	atexit(func);
#else
	on_exit((int ((*)())) func, (char *) 0);
#endif
}
