dnl -*- shell-script -*-

# Copyright 1998-1999, University of Notre Dame.
# Authors: Jeffrey M. Squyres, Kinis L. Meyer, with M. D. McNally 
#          and Andrew Lumsdaine
#
# This file is part of the Notre Dame LAM implementation of MPI.
#
# You should have received a copy of the License Agreement for the
# Notre Dame LAM implementation of MPI along with the software; see
# the file LICENSE.  If not, contact Office of Research, University of
# Notre Dame, Notre Dame, IN 46556.
#
# Permission to modify the code and to distribute modified code is
# granted, provided the text of this NOTICE is retained, a notice that
# the code was modified is included with the above COPYRIGHT NOTICE and
# with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
# file is distributed with the modified code.
#
# LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
# By way of example, but not limitation, Licensor MAKES NO
# REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
# PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
# OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
# OR OTHER RIGHTS.
#
# Additional copyrights may follow.
#

define(LAM_ANSI_PROTOS,[
# Determine if compiler and options accepts ANSI prototypes.
AC_MSG_CHECKING([whether the C compiler ($CC $CFLAGS) accepts ANSI prototypes])
cat > conftest.c <<EOF
static double foo(double bar) { return(2.0*bar); }
int main(int argc, char **argv)
{ double x; x = foo(2.0); return(0); }
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_ansi_protos=yes
else
    lam_ac_ansi_protos=no
fi
AC_MSG_RESULT($lam_ac_ansi_protos)
/bin/rm -f conftest*])dnl

define(LAM_CHECK_STDC,[
# Check to see if compiler sets __STDC__ to 1 or not
AC_MSG_CHECKING(for __STDC__)
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
#ifndef __STDC__
#define __STDC__ -1
#endif
int main(int argc, char* argv[])
{
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", __STDC__);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_stdc=`cat conftestval`
    AC_MSG_RESULT([$lam_ac_stdc])
    if test "$lam_ac_stdc" = "0"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__ to 1!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    elif test "$lam_ac_stdc" = "-1"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    fi
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])dnl

define(LAM_GET_ALIGNMENT,[
# Determine datatype alignment. 
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(alignment of $1)
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
void exit(int);
struct foo { char c; $1 x; };
int main(int argc, char* argv[])
{
    struct foo *p = (struct foo *) malloc(sizeof(struct foo));
    int diff;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    diff = ((char *)&p->x) - ((char *)&p->c);
    fprintf(f, "%d\n", (diff >= 0) ? diff : -diff);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_align=`cat conftestval`
    AC_MSG_RESULT($lam_ac_align)
    if test -n "$2"; then
	AC_DEFINE_UNQUOTED($2,$lam_ac_align)
    fi
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])dnl

define(LAM_GET_SIZEOF,[
# Determine datatype size. 
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of $1)
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
int main(int argc, char* argv[])
{
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    fprintf(f, "%d\n", sizeof($1));
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_size=`cat conftestval`
else
    lam_ac_size=0
fi
AC_MSG_RESULT($lam_ac_size)
if test -n "$2"; then
    AC_DEFINE_UNQUOTED($2,$lam_ac_size)
fi
/bin/rm -f conftest*])dnl


define(LAM_CHECK_SIZEOF_STRUCT_STAT_MEMBERS,[
# Determine size of members of struct stat
AC_MSG_CHECKING(size of struct stat members)
cat > conftest.c <<EOF
#include <sys/stat.h>
#include <stdio.h>
main()
{
    struct stat foo;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", sizeof(foo.st_dev));
    exit(0);
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_stat_size=`cat conftestval`
else
    lam_stat_size=0
fi
AC_MSG_RESULT($lam_stat_size)
if test "$lam_stat_size" = "4"; then
    AC_DEFINE(LAM_STAT_MEMBERS_INT4, 1)
else
    AC_DEFINE(LAM_STAT_MEMBERS_INT4, 0)
fi
/bin/rm -f conftest*])dnl


define(LAM_CHECK_TYPE,[
# Autoconfs AC_CHECK_TYPE is not sufficient
# This, too, is not foolproof, but will have to do...
AC_MSG_CHECKING(for type $1)
cat > conftest.$ac_ext <<EOF
#line 3411 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
touch conftest.out >&5 2>&5
rm -f conftest.out >&5 2>&5
eval "$ac_cpp conftest.$ac_ext" 2>&5 > conftest.out
egrep "$1[[^a-zA-Z_0-9]]" conftest.out > conftest.out2 2>&5
cat conftest.out2 >&5
out="`cat conftest.out2`"
if test "$out" != ""; then
  AC_DEFINE(LAM_HAVE_$1, 1)
  AC_MSG_RESULT([yes])
else
  AC_DEFINE(LAM_HAVE_$1, 0)
  AC_MSG_RESULT([no])
fi
rm -rf conftest*
])dnl

define(LAM_CHECK_TYPEOF_GETSOCKOPT_OPTLEN,[
# Determine type of optlen parameter of getsockopt()
AC_MSG_CHECKING(type of getsockopt optlen parameter)

try_getsockopt_optlen() {
    cat > conftest.c <<EOF
#include <sys/types.h>  
#include <sys/socket.h> 
int foobar(void *optval)
{
    $type optlen=0;
    return getsockopt(0, SOL_SOCKET, SO_SNDBUF, optval, &optlen);
}
EOF
    cat conftest.c >&5
    $CC $CFLAGS -c conftest.c 1> conftest.out 2>&1
    cat conftest.out >&5
    foo="wc conftest.out | awk '{ print $"
    foo="${foo}1 }'"
    ret=`eval $foo`
    rm -f conftest.*
}

types="socklen_t int size_t unsigned-int long unsigned-long"
for type in $types; do
    type=`echo $type | sed 's/-/ /g'`
    try_getsockopt_optlen
    if test "$ret" = "0"; then
        break
    fi
done
AC_DEFINE_UNQUOTED(LAM_SOCK_OPTLEN_T, $type)
AC_MSG_RESULT([$type])])dnl


define(LAM_CHECK_TYPEOF_RECVFROM_LEN,[
# Determine type of optlen parameter of getsockopt()
AC_MSG_CHECKING(type of recvfrom length parameter)

try_getsockopt_optlen() {
    cat > conftest.c <<EOF
#include <sys/types.h>  
#include <sys/socket.h> 
int foobar(void *buffer)
{
    $type optlen=0;
    return recvfrom(0, buffer, 0, 0, (struct sockaddr*) 0, &optlen);
}
EOF
    cat conftest.c >&5
    $CC $CFLAGS -c conftest.c 1> conftest.out 2>&1
    cat conftest.out >&5
    foo="wc conftest.out | awk '{ print $"
    foo="${foo}1 }'"
    ret=`eval $foo`
    rm -f conftest.*
}

types="socklen_t int size_t unsigned-int long unsigned-long"
for type in $types; do
    type=`echo $type | sed 's/-/ /g'`
    try_getsockopt_optlen
    if test "$ret" = "0"; then
        break
    fi
done
AC_DEFINE_UNQUOTED(LAM_RECVFROM_LEN_T, $type)
AC_MSG_RESULT([$type])])dnl


define(LAM_GET_FORTRAN_EXT_NAME_CONVENTION,[
# Determine underscore generation for external names.
# arg is FORTRAN compiler name
AC_MSG_CHECKING($1 external naming convention)
cat > conftestf.f <<EOF
       subroutine foo_bar(a)
       integer a
       a = 1
       return
       end
EOF
$1 $FFLAGS -c conftestf.f 1>&5 2>&1
if test ! -s conftestf.o; then
    AC_MSG_WARN(unable to produce an object file testing FORTRAN compiler)
else
    nm conftestf.o | grep foo_bar__ > /dev/null 2>&1
    if test $? = "0"; then 
	AC_MSG_RESULT(FORTRANDOUBLEUNDERSCORE)
	AC_DEFINE(LAM_FORTRANDOUBLEUNDERSCORE)
	lam_ac_doubleunder=y
    else
	nm conftestf.o | grep foo_bar_ > /dev/null 2>&1
	if test $? = "0"; then 
	    AC_MSG_RESULT(FORTRANUNDERSCORE)
	    AC_DEFINE(LAM_FORTRANUNDERSCORE)
	    lam_ac_singleunder=y
	else
	    nm conftestf.o | grep foo_bar > /dev/null 2>&1
	    if test $? = "0"; then 
		AC_MSG_RESULT(FORTRANNOUNDERSCORE)
		AC_DEFINE(LAM_FORTRANNOUNDERSCORE)
		lam_ac_nounder=y
	    else
		nm conftestf.o | grep FOO_BAR > /dev/null 2>&1
		if test $? = "0"; then 
		    AC_MSG_RESULT(FORTRANCAPS)
		    AC_DEFINE(LAM_FORTRANCAPS)
		    lam_ac_caps=y
		else
		    AC_MSG_WARN(couldn't find name of subroutine foo_bar)
		fi
	    fi
	fi
    fi
fi
/bin/rm -f conftestf.f conftestf.o])dnl
dnl #$%#% emacs shell-script mode: '

define(LAM_GET_SIZEOF_FORTRAN_TYPE,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of FORTRAN $1)
lam_ac_size_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_size_fn=size_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_size_fn=size
    else 
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_size_fn=SIZE
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_size_fn"; then
cat > conftestf.f <<EOF
       program fsize
       external size
       $1 x(2)
       call size(x(1),x(2))
       end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_size_fn(char *a, char *b)
{
    int diff = (int) (b - a);
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", diff);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_fortsize=`cat conftestval`
	AC_MSG_RESULT($lam_ac_fortsize)
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_fortsize)
	fi
    else
	AC_MSG_WARN(Error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl

define(LAM_GET_FORTRAN_ALIGNMENT,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(alignment of FORTRAN $1)
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external align
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call align(w,x,y,z)
      end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_alignment=`cat conftestval`
	AC_MSG_RESULT $lam_ac_alignment
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_alignment)
	fi
    else
	AC_MSG_WARN(error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl

define(LAM_GET_ALIGNMENT_CACHE,[
# Determine datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of $1,$2,[
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
struct foo { char c; $1 x; };
int main(int argc, char* argv[])
{
    struct foo *p = (struct foo *) malloc(sizeof(struct foo));
    int diff;
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    diff = ((char *)&p->x) - ((char *)&p->c);
    fprintf(f, "%d\n", (diff >= 0) ? diff : -diff);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    $2=`cat conftestval`
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

define(LAM_GET_SIZEOF_FORTRAN_TYPE_CACHE,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(size of FORTRAN $1,$2,[
lam_ac_size_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_size_fn=size_
else
    if test "x$lam_ac_nounder" = xy; then
	lam_ac_size_fn=size
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_size_fn=SIZE
	else 
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_size_fn"; then
cat > conftestf.f <<EOF
       program fsize
       external size
       $1 x(2)
       call size(x(1),x(2))
       end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
#endif
void $lam_ac_size_fn(char *a, char *b)
{
    int diff = (int) (b - a);
    FILE *f=fopen("conftestval", "w");
    if (!f) return;
    fprintf(f, "%d\n", diff);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	$2=`cat conftestval`
    else
	AC_MSG_WARN(Error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

define(LAM_GET_FORTRAN_ALIGNMENT_CACHE,[
# Determine FORTRAN datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of FORTRAN $1,$2,[
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external align
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call align(w,x,y,z)
      end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	$2=`cat conftestval`
    else
	AC_MSG_WARN(error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

define(LAM_CHECK_FUNC,[
# Determine if function taking void args is available. 
# First arg is function, 2nd arg is config var to define, 3rd arg is options
# to add to link line.
AC_MSG_CHECKING(for $1)
/bin/rm -f conftest*
cat > conftest.c <<EOF
int main(int argc, char* argv[]) { $1(); return(0); }
EOF
$CC $CFLAGS -o conftest conftest.c $3 1>&5 2>&1
if test -s conftest && ./conftest 2>/dev/null; then
    AC_DEFINE($2)
    AC_MSG_RESULT(yes)
else
    AC_MSG_RESULT(no)
fi
/bin/rm -f conftest*])dnl

define(LAM_GET_SHMMAX,[
# Determine maximum shared segment size.
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#define LAM_SHMSHORT $1
#define LAM_SHMPOOL $$2
#define MB (1024*1024)
int
test_alloc(int size)
{
    char		*base;
    int			shmid;
    shmid = shmget(IPC_PRIVATE, size, 0600 | IPC_CREAT);
    if (shmid < 0) return(0);
    base = (char *) shmat(shmid, (char *) 0, 0);
    if (base == (char *) -1) {
	shmctl(shmid, IPC_RMID, (struct shmid_ds *) 0);
	return(0);
    }
    shmdt(base);
    shmctl(shmid, IPC_RMID, (struct shmid_ds *) 0);
    return(1);
}
int
main(int argc, char* argv[])
{
    int	poolsize, maxalloc;
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    if (LAM_SHMPOOL > 0) {
	if (LAM_SHMPOOL >= 2 * MB) maxalloc = MB;
	else maxalloc = LAM_SHMPOOL;
        fprintf(f, "%d\t%d\t%d\n", 0, LAM_SHMPOOL, maxalloc);
	fclose(f);
	return(0);    
    }
    if (test_alloc(32*MB)) { poolsize = 16*MB; maxalloc = MB; }
    else if (test_alloc(16*MB)) { poolsize = 14*MB; maxalloc = MB; }
    else if (test_alloc(8*MB)) { poolsize = 6*MB; maxalloc = MB; }
    else if (test_alloc(4*MB)) { poolsize = 2*MB; maxalloc = MB; }
    else if (test_alloc(2*MB)) { poolsize = MB; maxalloc = MB/2; }
    else if (test_alloc(MB)) { 
	poolsize = MB - (8*7 * (LAM_SHMSHORT+128)) - 256; 
	if (poolsize < 0) poolsize =  MB - (4*3 * (LAM_SHMSHORT+128)) - 256;
	if (poolsize < 0) poolsize = 0; 
        maxalloc = poolsize; }
    else { poolsize = 0; maxalloc = 0; }
    fprintf(f, "%d\t%d\n", poolsize, maxalloc);
    fclose(f);
    return(0);
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    if test [$]$2 -eq 0; then
	$2=`cat conftestval | cut -f1`
    fi
    if test [$]$3 -eq 0; then
	$3=`cat conftestval | cut -f2`
    fi
else
    echo
    AC_MSG_WARN(error compiling/running conftest)
    lam_echo "using default of"
    if test [$]$2 -eq 0; then
	$2=524288
    fi
    if test [$]$3 -eq 0; then
	$3=524288
    fi
fi
/bin/rm -f conftest*])dnl

define(LAM_MUTEX_PSHARED,[
AC_MSG_CHECKING(for process shared pthread mutex)
AC_TRY_RUN([#include <pthread.h>
int main(int argc, char* argv[]) {
  pthread_mutex_t m; pthread_mutexattr_t mattr;
  if (pthread_mutexattr_init(&mattr)) return(1);
  if (pthread_mutexattr_setpshared(&mattr, PTHREAD_PROCESS_SHARED)) return(1);
  if (pthread_mutex_init(&m, &mattr)) return(-1);
  return(0);
}], lam_ac_mutex_pshared=yes, lam_ac_mutex_pshared=no, lam_ac_mutex_pshared=no)
AC_MSG_RESULT($lam_ac_mutex_pshared)
])

define([LAM_CXX_TEMPLATE_REPOSITORY],[
#
# See if the compiler makes template repository directories
# Warning: this is a really screwy example! -JMS
#
# Sets TEMPLATE_REP to the directory name, or blank
# Does AC_SUBST on TEMPLATE_REP
#

AC_MSG_CHECKING([for template repository directory])
mkdir conf_tmp_$$
cd conf_tmp_$$
cat > conftest.h <<EOF
template <class T>
class foo {
public:
  foo(T yow) : data(yow) { yow.member(3); };
  void member(int i);
private:
  T data;
};

class bar {
public:
  bar(int i) { data = i; };
  void member(int j) { data = data * j; };

private:
  int data;
};
EOF

cat > conftest2.C <<EOF
#include "conftest.h"

void
some_other_function(void)
{
  foo<bar> var1(6);
  foo< foo<bar> > var2(var1);
}
EOF

cat > conftest1.C <<EOF
#include "conftest.h"

void some_other_function(void);

template <class T>
void
foo<T>::member(int i)
{
  i += 2;
}

int
main(int argc, char *argv[])
{
  foo<bar> var1(6);
  foo< foo<bar> > var2(var1);

  some_other_function();
  return 0;
}
EOF

echo configure:__oline__: $CXX -c conftest1.C >&5
$CXX -c conftest1.C >/dev/null 2>/dev/null
if test ! -f conftest1.o ; then
    AC_MSG_RESULT([templates not supported?])
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest1.C >&5
    echo configure:__oline__: here is conftest.h: >&5
    cat conftest.h >&5
else
    echo configure:__oline__: $CXX -c conftest2.C >&5
    $CXX -c conftest2.C >/dev/null 2>/dev/null
    if test ! -f conftest2.o ; then
	AC_MSG_RESULT([unknown error])
	echo configure:__oline__: here is the program that failed: >&5
	cat conftest2.C >&5
	echo configure:__oline__: here is conftest.h: >&5
	cat conftest.h >&5
    else
	rm -rf conftest*

	for file in `ls`
	do
	    if test "$file" != "." -a "$file" != ".."; then
		# Is it a directory?
		if test -d "$file"; then
		    TEMPLATE_DIR="$file $TEMPLATE_DIR"
		    
		# Or is it a file?
		else
		    name="`echo $file | cut -d. -f1`"
		    
		    temp_mask=
		    if test "$name" = "main" -o "$name" = "other"; then
			temp_mask="`echo $file | cut -d. -f2`"
			if test "$TEMPLATE_FILEMASK" = ""; then
			TEMPLATE_FILEMASK="$temp_mask";
			elif test "`echo $TEMPLATE_FILEMASK | grep $temp_mask`" = ""; then
			TEMPLATE_FILEMASK="$TEMPLATE_FILEMASK $temp_mask"
			fi
		    fi
		fi
	    fi
	done
	if test "$TEMPLATE_FILEMASK" != ""; then
	    temp_mask=
	    for mask in $TEMPLATE_FILEMASK
	    do
		temp_mask="*.$mask $temp_mask"
	    done
	    TEMPLATE_FILEMASK=$temp_mask
	fi
    fi
fi
TEMPLATE_REP="$TEMPLATE_DIR $TEMPLATE_FILEMASK"

if test "$TEMPLATE_REP" != "" -a "$TEMPLATE_REP" != " "; then
    AC_MSG_RESULT([$TEMPLATE_REP])
else
    AC_MSG_RESULT([not used])
fi
cd ..
rm -rf conf_tmp_$$
AC_SUBST(TEMPLATE_REP)dnl
])dnl

define([LAM_CHECK_PROTOTYPE],[
AC_MSG_CHECKING([for prototype of $1])
func=$1
rm -f conftest.c
cat > conftest.c <<EOF
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <strings.h>
#include <netdb.h>
#include <unistd.h>

int main(int argc, char **argv)
{ return 0; }
EOF
echo configure:__oline__: $CPP $CFLAGS conftest.c >&5
$CPP $CFLAGS conftest.c > conftest.out 2>&5
e1="egrep '[[^A-Za-z0-9_]]$func[[	 ]]*\(' conftest.out"
e2="egrep '^$func[[	 ]]*\(' conftest.out"
if test "`eval $e1`" != "" -o "`eval $e2`" != ""; then
    AC_DEFINE_UNQUOTED(LAM_HAVE_${func}_PROTO, 1)
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.c >&5
    AC_DEFINE_UNQUOTED(LAM_HAVE_${func}_PROTO, 0)
    AC_MSG_RESULT([no])
fi
rm -f conftest*
])dnl

define([LAM_CHECK_CXX_NOTHROW_NEW],[
#
# Check to see if the C++ compiler has std::nothrow support for new
# and new[]
#
# Defines LAM_NOTHROW_NEW to be either "(std::nothrow)" or ""
# Defines LAM_HAVE_NOTHROW_NEW to be either 1 or 0
# Sets LAM_NOTHROW_NEW to be 1 or 0
#

if test "$?CXXFLAGS" = 0; then
    CXXFLAGS=""
fi
AC_MSG_CHECKING([whether $CXX has new(std::nothrow)])
rm -f conftest.cc conftest.o
cat > conftest.cc <<EOF
#include <new>

int main(int argc, char* argv[]) {
  int *baz;
  unsigned int foo = 3;
  baz = new(std::nothrow) int;
  baz = new(std::nothrow) int[[foo - 1]];
}
EOF
echo configure:__oline__: $CXX $CXXFLAGS conftest.cc -o conftest >&5 
$CXX $CXXFLAGS conftest.cc -o conftest >&5 2>&5
if test -f conftest; then
    LAM_HAVE_NOTHROW_NEW=1
    AC_DEFINE(LAM_NOTHROW_NEW, (std::nothrow))
    AC_DEFINE(LAM_HAVE_NOTHROW_NEW, 1)
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.cc >&5
    LAM_HAVE_NOTHROW_NEW=0
    AC_DEFINE(LAM_NOTHROW_NEW, )
    AC_DEFINE(LAM_HAVE_NOTHROW_NEW, 0)
    AC_MSG_RESULT([no])
fi
rm -f conftest*
])dnl

define([LAM_CHECK_CXX_EXCEPTIONS],[
#
# Check to see if the C++ compiler can handle exceptions 
#
# Sets LAM_CXX_HAS_EXCEPTIONS to 1 if compiler has exceptions, 0 if not
#

AC_MSG_CHECKING([for throw/catch])
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE(, int i=1; throw(i);, have_excep=yes, have_excep=no)
if test "$have_excep" = "yes"; then
    LAM_CXX_HAS_EXCEPTIONS=1
    AC_MSG_RESULT([yes])
else
    LAM_CXX_HAS_EXCEPTIONS=0
    AC_MSG_RESULT([no])
fi
AC_LANG_RESTORE])dnl


define([LAM_CHECK_CXX_EXCEPTION_FLAGS],[
#
# Get the exception handling flags for the C++ compiler
#
# Sets LAM_EXCEPTION_CXXFLAGS and LAM_EXCEPTION_LDFLAGS as appropriate
# Calls AC_SUBST on both
#

AC_ARG_WITH(exflags,   [--with-exflags          Specify flags necessary to enable C++ exceptions], FORCE_EXFLAGS=$withval)

CXXFLAGS_SAVE=$CXXFLAGS
AC_MSG_CHECKING([for $CXX exception flags])
if test "$FORCE_EXFLAGS" != ""; then
    EXFLAGS=$FORCE_EXFLAGS
elif test "$GXX" = "yes"; then
    CXXFLAGS="$CXXFLAGS -fexceptions"

    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE(, [try { int i = 0; } catch(...) { int j = 2; }], HAPPY=1, HAPPY=0)

    if test "$HAPPY" = "1"; then
	EXFLAGS="-fexceptions";
    else
	CXXFLAGS="$CXXFLAGS_SAVE -fhandle-exceptions"
	AC_TRY_COMPILE(, [try { int i = 0; } catch(...) { int j = 2; }], HAPPY=1, HAPPY=0)
	if test "$HAPPY" = "1"; then
	    EXFLAGS="-fhandle-exceptions";
	fi
    fi
    AC_LANG_RESTORE
elif test "$CXX" = "KCC" -o "$LAMHCP" = "KCC"; then
    EXFLAGS="-x"
fi
CXXFLAGS=$CXXFLAGS_SAVE

LAM_EXCEPTION_CXXFLAGS=$EXFLAGS
LAM_EXCEPTION_LDFLAGS="$EXFLAGS"
if test "$EXFLAGS" = ""; then
    AC_MSG_RESULT([none necessary])
else
    AC_MSG_RESULT([$EXFLAGS])
fi
AC_SUBST(LAM_EXCEPTION_CXXFLAGS)
AC_SUBST(LAM_EXCEPTION_LDFLAGS)])dnl

define([LAM_CHECK_CXX_BOOL],[
#
# Check to see if the C++ compiler has the bool type.  <sigh>
#
# Defines LAM_HAVE_BOOL to be 1 or 0
#

if test "$?CXXFLAGS" = 0; then
    CXXFLAGS=""
fi
AC_MSG_CHECKING([for type bool])
rm -f conftest.cc conftest.o
cat > conftest.cc <<EOF
#include <stdio.h>
#include <sys/types.h>

int main(int argc, char* argv[]) {
  bool foo = (bool) 0;
  printf("so foo is used and the compiler wont complain: %d", (int) foo);
  return 0;
}
EOF
echo configure:__oline__: $CXX $CXXFLAGS conftest.cc -o conftest >&5 
$CXX $CXXFLAGS conftest.cc -o conftest >&5 2>&5
if test -f conftest; then
    AC_DEFINE(LAM_HAVE_BOOL, 1)
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.cc >&5
    AC_DEFINE(LAM_HAVE_BOOL, 0)
    AC_MSG_RESULT([no])
fi
rm -f conftest*
])dnl

define([LAM_CHECK_CXX_TRUE_FALSE],[
#
# Check to see if the C++ compiler has "true" and "false" defined.  <sigh>
#
# Defines LAM_HAVE_TRUE_FALSE to be 1 or 0
#

if test "$?CXXFLAGS" = 0; then
    CXXFLAGS=""
fi
AC_MSG_CHECKING([for true/false])
rm -f conftest.cc conftest.o
cat > conftest.cc <<EOF
#include <stdio.h>
#include <sys/types.h>

int main(int argc, char* argv[]) {
  int foo;
  foo = (int) true;
  foo = (int) false;
  printf("so foo is used and the compiler wont complain: %d", (int) foo);
  return 0;
}
EOF
echo configure:__oline__: $CXX $CXXFLAGS conftest.cc -o conftest >&5 
$CXX $CXXFLAGS conftest.cc -o conftest >&5 2>&5
if test -f conftest; then
    AC_DEFINE(LAM_HAVE_TRUE_FALSE, 1)
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.cc >&5
    AC_DEFINE(LAM_HAVE_TRUE_FALSE, 0)
    AC_MSG_RESULT([no])
fi
rm -f conftest*
])dnl

define([LAM_CXX_HAS_STL],[
#
# See if the compiler has STL
#
# Set LAM_CXX_STL to 1 if so, 0 if not
# AC_DEFINE LAM_CXX_STL to 1 if so, 0 if not
#

AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_CHECK_HEADER(map, LAM_CXX_STL=1, LAM_CXX_STL=0)
if test "$LAM_CXX_STL" = "1"; then
    AC_DEFINE(LAM_CXX_STL, 1)
else
    AC_DEFINE(LAM_CXX_STL, 0)
fi
AC_LANG_RESTORE])dnl

