//LabPlot : CompressListDialog.h

#ifndef COMPRESSLISTDIALOG_H
#define COMPRESSLISTDIALOG_H

#include "ListDialog.h"

class CompressListDialog : public ListDialog
{
	Q_OBJECT
public:
	CompressListDialog(MainWin *mw, const char *name);
public slots:
	void setN(int n) { nni->setValue(n); }				//!< set number of points to compress
	void setAverage(bool a=true) {	averagecb->setChecked(a); }	//!< average points
	void enableAverage(bool e=true) { setAverage(e); }
	int Apply() { return apply_clicked(); }
private:
	KIntNumInput *nni;
	QCheckBox *averagecb;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // COMPRESSLISTDIALOG_H
