/***************************************************************************
 *
 *  $Id: kzentrack.h,v 1.11 2005/06/04 10:22:21 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENTRACK_H
#define KZENTRACK_H

#include <libnjb.h>

#include <klistview.h>

#include <qbitarray.h>

#include "kzenglobal.h"

class KZenPlayList;
class KZenArtist;
class KZenAlbum;
class KZenGenre;
class KZenTrackItem;

/**
@author Andreas Mussgiller
*/
class KZenTrack {
  
 public:
  
  enum CodecType {
    CodecMP3 = 0,
    CodecWMA = 1,
    CodecWAV = 2,
    CodecUNKNOWN
  };

  KZenTrack();
  KZenTrack(njb_songid_t * song);
  ~KZenTrack();

  static uint                 version() { return 2; }

  bool                        needsWrite();
  void                        compress();

  uint                        getTrackID() { return fTrackID; }
  const QString &             getArtist() { return fArtist; }
  const QString &             getAlbum() { return fAlbum; }
  const QString &             getTitle() { return fTitle; }
  uint                        getTrackNumber() { return fTrackNumber; }
  uint                        getLength() { return fLength; }
  const QString &             getGenre() { return fGenre; }
  uint                        getYear() { return fYear; }
  const QString &             getFileName() { return fFileName; }
  uint                        getFileSize() { return fFileSize; }
  CodecType                   getCodec() { return fCodec; }
  const char *                getCodecName(); 
  uint                        getRating() { return fRating; }
  QBitArray &                 getCategories() { return fCategories; }
  bool                        getIsCompilation() { return fIsCompilation; }

  void                        setTrackID(uint TrackID);
  void                        setArtist(const char * Artist);
  void                        setAlbum(const char * Album);
  void                        setTitle(const char * Title);
  void                        setTrackNumber(uint TrackNumber);
  void                        setLength(uint Length);
  void                        setGenre(const char * Genre);
  void                        setYear(uint Year);
  void                        setFileName(const char * FileName);
  void                        setFileSize(uint size);
  void                        setCodec(CodecType codec);
  void                        setRating(uint rating);
  void                        setCategory(uint idx, bool);
  void                        setCategories(const QBitArray &);
  void                        removeCategory(uint idx);
  void                        setIsCompilation(bool c);

  KZenArtist *                getZenArtist() { return fZenArtist; }
  void                        setZenArtist(KZenArtist * a) { fZenArtist = a; }

  KZenAlbum *                 getZenAlbum() { return fZenAlbum; }
  void                        setZenAlbum(KZenAlbum * a) { fZenAlbum = a; }

  KZenGenre *                 getZenGenre() { return fZenGenre; }
  void                        setZenGenre(KZenGenre * a) { fZenGenre = a; }

  KZenTrackItem *             getItem() { return fItem; }
  void                        setItem(KZenTrackItem * i) { fItem = i; }

  void                        refresh();

  static QStringList &        getTitles();

 protected:

  uint                        fTrackID;
  QString                     fArtist;
  QString                     fAlbum;
  QString                     fTitle;
  uint                        fTrackNumber;
  uint                        fLength;
  QString                     fGenre;
  uint                        fYear;
  QString                     fFileName;
  uint                        fFileSize;
  CodecType                   fCodec;
  uint                        fRating;
  QBitArray                   fCategories;
  bool                        fIsCompilation;        // version 2

  KZenTrackItem              *fItem;
		     
  KZenArtist                 *fZenArtist;
  KZenAlbum                  *fZenAlbum;
  KZenGenre                  *fZenGenre;

  static QStringList          fTitles;
};

bool operator==(const QBitArray &ba1, const QBitArray &ba2);

class KZenTrackItem : public KListViewItem , public KZen
{
  friend class KZenTrack;

 public:
  
  KZenTrackItem(QListView * parent, KZenTrack * Track);
  KZenTrackItem(QListView * parent, QListViewItem * after, KZenTrack * Track);
  ~KZenTrackItem();

  KZenTrack *                 getTrack() { return fTrack; }
  KZenTrack *                 getTrack() const { return fTrack; }

  int                         compare(QListViewItem * i, int col, bool ascending) const;

  virtual void                paintCell(QPainter *, const QColorGroup & cg,
					int column, int width, int alignment);

 protected:

  void                        init();

  KZenTrack                  *fTrack;
};

class KZenTrackPLItem : public KZenTrackItem
{
 public:

  KZenTrackPLItem(QListView * parent, KZenTrack * Track, 
		  KZenPlayList * PL);
  KZenTrackPLItem(QListView * parent, QListViewItem * after,
		  KZenTrack * Track, KZenPlayList * PL);
  ~KZenTrackPLItem();

  KZenPlayList *              getPlayList() { return fPlayList; }

 protected:

  KZenPlayList               *fPlayList;
};

#endif
