/***************************************************************************
 *
 *  $Id: kzensmartplaylist.h,v 1.5 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENSMARTPLAYLIST_H
#define KZENSMARTPLAYLIST_H

#include <libnjb.h>

#include <qptrlist.h>
#include <qvariant.h>
#include <qdatastream.h>
#include <qwidget.h>
#include <qhbox.h>
#include <qwidgetstack.h>

#include "kzenplaylist.h"
#include "kzenitem.h"

class KComboBox;
class KLineEdit;
class KIntNumInput;
class KZenRatingWidget;

class KZenSmartPlayListCondition;

class KZenSearch;

typedef QPtrList<KZenSmartPlayListCondition> KZenConditionList;

/**
@author Andreas Mussgiller
*/
class KZenSmartPlayList : public KZenPlayList
{
 public:
  
  KZenSmartPlayList(const char * name);
  KZenSmartPlayList(KZenSmartPlayList *);
  virtual ~KZenSmartPlayList();

  static uint                 version() { return 1; }

  void                        init(njb_playlist_t * pl, QPtrList<KZenTrack> *);
  void                        refresh(KZenTrack *);
  void                        refresh(QPtrList<KZenTrack> *);
  bool                        checkTrack(KZenTrack *);
  void                        addTrack(KZenTrack *);

  KZenSearch *                getSearch() { return fSearch; }

  void                        assign(KZenSmartPlayList *);

 protected:

  KZenSearch                 *fSearch;
};

class KZenSmartPlayListItem : public KZenPlayListItem
{
 public:
  
  KZenSmartPlayListItem(QListView * parent, KZenSmartPlayList * PlayList);
  ~KZenSmartPlayListItem();

 protected:
  
};

QDataStream & operator<<(QDataStream & s, KZenSmartPlayList & spl);
QDataStream & operator>>(QDataStream & s, KZenSmartPlayList & spl);

#endif
