/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FLOSSSCHEME_H
#define FLOSSSCHEME_H

#include <qstring.h>
#include <qptrlist.h>
#include "floss.h"

/** FlossScheme details a set of flosses attributed to a specific palette.
    This may be a floss manufacturers scheme, eg DMC, Anchor, etc,
    or a user can create their own schemes which can
    then be used as a basis for new patterns or
    importing pictures.
    @author Stephen P Allewell
  */
class FlossScheme
{
public:
/** Constructor
  */
  FlossScheme();

/** Get the name of this scheme.
    @return The name of the scheme.
  */
  QString schemeName();

/** Set the scheme name.
    @param name The name to use.
  */
  void setSchemeName(QString name);
/** Add a floss to this scheme.
    @param floss Pointer to the floss to be added.
  */
  void addFloss(Floss *floss);
/** Find a floss by name.
    @return A pointer to the floss. Returns NULL if no floss found by that name.
    @param name The name of the floss required.
  */
  Floss *find(QString name);
/** Get an iterator to the list of flosses.
    @return A QListIterator for the Floss class.
  */
  QPtrListIterator<Floss> flossIterator();
/** Clear the contents of the scheme
  */
  void clearScheme();

private:
  QString          m_name;
  QPtrList<Floss>  m_flosses;
};

#endif
