/***************************************************************************
                          kxe_viewelement.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_VIEWELEMENT_H
#define KXE_VIEWELEMENT_H

#include <qsplitter.h>

class TableWidget;
class QMultiLineEdit;
class XmlElement;

/**
 * This widget shows a table of XML elements attributes
 * and plain XML text of this element and its children.
 *
 * @short widget for XML elements
 */
class KXE_ViewElement : public QSplitter
{
		Q_OBJECT

	public:

		KXE_ViewElement( QWidget * pParent, const char * pszName = 0 );

	public slots:

		/** Changes/Rebuilds the whole widget according to the given element. */
		void slotChange( XmlElement * const );

	protected:

		/** table widget to display XML attributes */
		TableWidget * m_pTableAttributes;
		/** edit widget for plain XML */
		QMultiLineEdit * m_pEditPlainXML;
};

#endif
