#ifndef KPROFILECONFIGDLG_H
#define KPROFILECONFIGDLG_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kprofileconfig.h"
#include "kwlanmainwin.h"

class KWlanInterface;

class KProfileConfigDlg : public KProfileConfig
{
  Q_OBJECT

public:
  KProfileConfigDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KProfileConfigDlg();
  /*$PUBLIC_FUNCTIONS$*/
  virtual void          setInterface( KWlanInterface * interface );
  virtual void          getEapCapa();
  virtual void          wepEnabled( bool enabled );
  virtual void          newNetwork();
  virtual void          paramsFromConfig( KWlanInterface *interface, QString ssid );
  virtual int           setNetworkParam( int id, const char * field, const char * value, bool quote );
  virtual void          paramsFromScanResults( QListViewItem * sel );

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          dnsRemoveDomain();
  virtual void          dnsAddDomain();
  virtual void          setMainWin( KWlanMainWin * mainWin );
  virtual void          dhcpState(int state);
  virtual void          browseForServerCertificate();
  virtual void          browseForPrivateKey();
  virtual void          browseForCertificate();
  virtual void          writeWepKey( int network_id, QLineEdit * edit, int id );
  virtual void          encrChanged( const QString & sel );
  virtual void          addNetwork();
  virtual void          authChanged( int sel );

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
    
signals:
        void                  profileAdded();

private:
  KWlanInterface *m_interface;
  int m_editNetworkID;
  bool m_newNetwork;
};

#endif









