// =============================================================================
//
//      --- kvi_tabdialog_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>
#include <qgrid.h>
#include <qhbox.h>
#include <qvbox.h>

#include "kvi_locale.h"
#include "kvi_tabdialog_qt.h"

KviTabDialog::KviTabDialog(QWidget *parent, const char *name, bool modal, const QString &caption, int buttonMask)
	: QTabDialog(parent, name, modal)
{
	setCaption(caption);
	m_pageIndex.setAutoDelete(false);
	if( buttonMask && Apply  ) setApplyButton();
	if( buttonMask && Cancel ) setCancelButton();
	if( buttonMask && Help   ) setHelpButton();
	if( buttonMask && Ok     ) setOkButton();
	connect(this, SIGNAL(applyButtonPressed()),  this, SIGNAL(applyClicked()));
	connect(this, SIGNAL(cancelButtonPressed()), this, SIGNAL(cancelClicked()));
	connect(this, SIGNAL(helpButtonPressed()),   this, SIGNAL(helpClicked()));
	connect(this, SIGNAL(applyButtonPressed()),  this, SIGNAL(okClicked()));
}

KviTabDialog::~KviTabDialog()
{
	// Nothing here
}

QFrame *KviTabDialog::addPage(const QString &itemName)
{
	QFrame *page = new QFrame(this);
	addNewPage(page, itemName);
	return page;
}

QGrid *KviTabDialog::addGridPage(int numRows, Orientation o, const QString &itemName)
{
	QGrid *page = new QGrid(numRows, o, this);
	addNewPage(page, itemName);
	return page;
}

QHBox *KviTabDialog::addHBoxPage(const QString &itemName)
{
	QHBox *page = new QHBox(this);
	addNewPage(page, itemName);
	return page;
}

QVBox *KviTabDialog::addVBoxPage(const QString &itemName)
{
	QVBox *page = new QVBox(this);
	addNewPage(page, itemName);
	return page;
}

void KviTabDialog::delayedDestruct()
{
	delete this;
}

void KviTabDialog::addNewPage(QWidget *w, const QString &name)
{
	int index = m_pageIndex.count();
	addTab(w, name);
	m_pageIndex.insert(++index, w);
}

int KviTabDialog::activePageIndex()
{
	QWidget *w = currentPage();
	for( unsigned int i = 0; i < m_pageIndex.count(); i++ ) {
		if( m_pageIndex.find(i) == w )
			return i;
	}
	return -1;
}

void KviTabDialog::showPage(int index)
{
	QWidget *w = m_pageIndex.find(index);
	if( w ) showPageForWidget(w);
}

void KviTabDialog::showPageForWidget(QWidget *w)
{
	QTabDialog::showPage(w);
}

void KviTabDialog::setButtonCancel()
{
	setCancelButton(_i18n_("&Cancel"));
}

void KviTabDialog::setButtonDefaultText(const QString &text)
{
	setDefaultButton(text);
}

void KviTabDialog::setButtonHelpText(const QString &text)
{
	setHelpButton(text);
}

void KviTabDialog::setButtonOK()
{
	setOkButton(_i18n_("&OK"));
}

#include "m_kvi_tabdialog_qt.moc"
