//////////////////////////////////////////////////////////////////////////
//   File : tkjbmp3file.h
//   Created : Wed Oct 18 2000 by Jason A. Cohen
//
//   Copyright (C) 2000 Jason A. Cohen timekepr@steltek.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef TKJBMP3FILE_H
#define TKJBMP3FILE_H

#include "defines.h"
//#include <qobject.h>
#include <qfileinfo.h>
#include <qlist.h>

class QString;

class TkjbMP3File //: public QObject
{
	//Q_OBJECT	

public:
	QFileInfo* m_pfi;

public:
	TkjbMP3File(){m_pfi=0;}
	TkjbMP3File(const QDir & d, const QString & fileName){	m_pfi = new QFileInfo(d,fileName);}
	TkjbMP3File(const QFileInfo& fi){	m_pfi = new QFileInfo(fi);}
	TkjbMP3File(const QFileInfo* pfi){ m_pfi = new QFileInfo(*pfi);}
	~TkjbMP3File(){if (m_pfi) delete m_pfi;}
};

typedef QList<TkjbMP3File> TkjbMP3ListBase;

class TkjbMP3FileList : public TkjbMP3ListBase
{
public:
    TkjbMP3FileList() { setAutoDelete(true); }
    ~TkjbMP3FileList()			{ clear(); }
    
    //TkjbMP3FileList& operator=( const TkjbMP3FileList & );
    //TkjbMP3FileList( const TkjbMP3FileList & );

// Public methods
public:
    bool makeHumanList(QString& fn,const char * nick);

private:
    void deleteItem( QCollection::Item f ) { if ( del_item ) delete (TkjbMP3File*) f; }
    int compareItems( QCollection::Item f1, QCollection::Item f2 );

};


#endif
